/*
 * Decompiled with CFR 0.152.
 */
package dataGraph;

import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;

public class Bar
extends SApplet
implements SDataListener {
    boolean isStandalone = false;
    double min;
    double max;
    boolean vert;
    int numBars = 1;
    EtchedBorder etchedBorder = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    double value = 0.0;
    Color negColor = Color.blue;
    Color posColor = Color.red;
    BarGraph bar = new BarGraph();
    BorderLayout borderLayout2 = new BorderLayout();
    SNumber valField = new SNumber();
    boolean showControls = false;
    boolean autoScale = false;
    Panel panel1 = new Panel();
    Label barLabel = new Label();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        int n = 10;
        String string = "";
        try {
            this.min = Double.valueOf(this.getParameter("Min", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.max = Double.valueOf(this.getParameter("Max", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.value = Double.valueOf(this.getParameter("Value", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.vert = Boolean.valueOf(this.getParameter("Vertical", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoScale = Boolean.valueOf(this.getParameter("AutoScale", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            n = Integer.parseInt(this.getParameter("BarWidth", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numBars = Integer.parseInt(this.getParameter("NumSeries", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = this.getParameter("Label", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.showControls) {
            this.panel1.setVisible(false);
        }
        this.valField.setValue(this.value);
        this.bar.barWidth = n;
        if (!string.equals("")) {
            this.barLabel.setText(string);
            this.barLabel.setVisible(true);
        }
        SApplet.addDataListener((Object)((Object)this));
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.bar.setLayout(this.borderLayout2);
        this.valField.setEditable(false);
        this.barLabel.setVisible(false);
        this.barLabel.setAlignment(2);
        ((Container)((Object)this)).add((Component)this.etchedBorder, "Center");
        ((Container)((Object)this)).add(this.panel1, "South");
        this.panel1.add((Component)this.barLabel, null);
        this.panel1.add((Component)this.valField, null);
        this.etchedBorder.add((Component)this.bar, "Center");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Min", "double", "Minimum value"}, {"Max", "double", "Maximum value"}, {"Vertical", "boolean", "Orientation"}};
        return stringArray;
    }

    public void setAutoscale(boolean bl) {
        this.autoScale = bl;
        this.bar.repaint();
    }

    public void setLabel(String string) {
        this.barLabel.setText(string);
        if (string.equals("")) {
            this.barLabel.setVisible(false);
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setBarWidth(int n) {
        this.bar.barWidth = n;
        this.bar.repaint();
    }

    public void setMax(double d) {
        this.max = d;
        this.bar.repaint();
    }

    public void setMin(double d) {
        this.min = d;
        this.bar.repaint();
    }

    public void setValue(double d) {
        if (this.autoScale) {
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
        }
        this.value = d;
        this.valField.setValue(d);
        this.bar.repaint();
    }

    public void setPosRGB(int n, int n2, int n3) {
        this.posColor = new Color(n, n2, n3);
    }

    public void setNegRGB(int n, int n2, int n3) {
        this.negColor = new Color(n, n2, n3);
    }

    public void setNumericFormat(String string) {
        this.valField.setFormat(string);
    }

    public void addDatum(int n, double d, double d2) {
        this.setValue(d);
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.setValue(d);
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return;
        }
        int n2 = dArray.length;
        if (n2 < 1) {
            return;
        }
        this.setValue(dArray[n2 - 1]);
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        this.addData(n, dArray, dArray2);
    }

    public void deleteSeries(int n) {
        this.setValue(0.0);
    }

    public void clearSeries(int n) {
        this.setValue(0.0);
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    class BarGraph
    extends Panel {
        int barWidth = 10;

        BarGraph() {
        }

        public void paint(Graphics graphics) {
            double d = 0.0;
            if (Bar.this.min <= 0.0 && Bar.this.max > 0.0) {
                d = 0.0;
            }
            int n = 0;
            int n2 = 0;
            int n3 = this.getBounds().width;
            int n4 = this.getBounds().height;
            if (Bar.this.vert) {
                int n5 = (int)(0.4999999 + (double)n4 * Bar.this.max / (Bar.this.max - Bar.this.min));
                if ((n4 = (int)((double)n4 * (Bar.this.value - d) / (Bar.this.max - Bar.this.min))) >= 0) {
                    n2 = n5 - n4;
                    graphics.setColor(Bar.this.posColor);
                } else {
                    n2 = n5;
                    n4 = -n4;
                    graphics.setColor(Bar.this.negColor);
                }
                graphics.fillRect(n3 / 2 - this.barWidth, n2, 2 * this.barWidth, n4);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n5, n3 - 1, n5);
            } else {
                int n6 = (int)(0.4999999 - (double)n3 * Bar.this.min / (Bar.this.max - Bar.this.min));
                if ((n3 = (int)((double)n3 * (Bar.this.value - d) / (Bar.this.max - Bar.this.min))) >= 0) {
                    n = n6;
                    graphics.setColor(Bar.this.posColor);
                } else {
                    n3 = -n3;
                    n = n6 - n3;
                    graphics.setColor(Bar.this.negColor);
                }
                graphics.fillRect(n, n4 / 2 - this.barWidth, n3, 2 * this.barWidth);
                graphics.setColor(Color.black);
                graphics.drawLine(n6, 0, n6, n4 - 1);
            }
        }
    }
}

