/*
 * Decompiled with CFR 0.152.
 */
package dataGraph;

import edu.davidson.display.ArrowThing;
import edu.davidson.display.BoxThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.ImageThing;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.TextThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataConnection;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;

public class DataGraph
extends SApplet {
    boolean isStandalone = false;
    boolean showControls = true;
    boolean autoX;
    boolean autoY;
    String function;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    String dataFile;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    SGraph graph = new SGraph((SApplet)this);
    Button clearSeriesBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button addDatumBtn = new Button();
    Button addFuncBtn = new Button();
    Button clearFuncBtn = new Button();
    TextField funcField = new TextField();
    SNumber yField = new SNumber();
    SNumber xField = new SNumber();
    BorderLayout borderLayout2 = new BorderLayout();
    Label label1 = new Label();
    Panel border1 = new Panel();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel border2 = new Panel();
    Panel border3 = new Panel();
    Label label2 = new Label();
    Label label3 = new Label();
    BorderLayout borderLayout4 = new BorderLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    Button button4 = new Button();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.function = this.getParameter("Function", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmin = Double.valueOf(this.getParameter("XMin", "-1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmax = Double.valueOf(this.getParameter("XMax", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymin = Double.valueOf(this.getParameter("YMin", "-1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymax = Double.valueOf(this.getParameter("YMax", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dataFile = this.getParameter("DataFile", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoX = Boolean.valueOf(this.getParameter("AutoScaleX", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoY = Boolean.valueOf(this.getParameter("AutoScaleY", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.showControls) {
            this.etchedBorder1.setVisible(false);
        }
        if (this.function != null && !this.function.equals("")) {
            this.funcField.setText(this.function);
        }
        this.graph.setEnableMouse(true);
        if (this.function != null && !this.function.equals("")) {
            this.graph.addFunction(this.function);
        }
        this.graph.setAutoscaleX(this.autoX);
        this.graph.setAutoscaleY(this.autoY);
        this.graph.setMinMaxX(this.xmin, this.xmax);
        this.graph.setMinMaxY(this.ymin, this.ymax);
        if (this.dataFile != null && !this.dataFile.equals("")) {
            this.graph.loadFile(1, this.dataFile);
        }
    }

    private void jbInit() throws Exception {
        this.etchedBorder1.setLayout(this.borderLayout2);
        this.etchedBorder1.setBackground(Color.lightGray);
        this.graph.setSampleData(false);
        this.graph.setLabelX("x");
        this.graph.setBorders("0,10,15,0");
        this.graph.setLabelY("y");
        this.clearSeriesBtn.setLabel("Clear");
        this.etchedBorder3.setLayout(this.borderLayout3);
        this.etchedBorder2.setLayout(this.borderLayout4);
        this.addDatumBtn.setLabel("Add");
        this.addDatumBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addDatumBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.setLabel("Plot");
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.clearFuncBtn.setLabel("Clear");
        this.clearFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.clearFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.funcField.setText("sin(2*pi*x)");
        this.label1.setAlignment(2);
        this.label1.setText("F(x) =");
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.border2.setLayout(this.flowLayout2);
        this.border3.setLayout(this.gridLayout1);
        this.label2.setAlignment(2);
        this.label2.setText("x = ");
        this.label3.setAlignment(2);
        this.label3.setText("y = ");
        this.flowLayout2.setHgap(0);
        this.flowLayout2.setVgap(0);
        this.button4.setLabel("Reset");
        this.button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.button4_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.borderLayout6);
        this.panel2.setLayout(this.borderLayout5);
        this.border1.setLayout(this.flowLayout1);
        this.clearSeriesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.clearSeriesBtn_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Component)((Object)this)).addComponentListener(new ComponentAdapter(){});
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "South");
        this.etchedBorder1.add((Component)this.etchedBorder3, "South");
        this.etchedBorder3.add((Component)this.border1, "East");
        this.border1.add((Component)this.addFuncBtn, null);
        this.border1.add((Component)this.clearFuncBtn, null);
        this.etchedBorder3.add((Component)this.label1, "West");
        this.etchedBorder3.add((Component)this.funcField, "Center");
        this.etchedBorder1.add((Component)this.etchedBorder2, "North");
        this.etchedBorder2.add((Component)this.border3, "Center");
        this.border3.add((Component)this.panel2, null);
        this.panel2.add((Component)this.label2, "West");
        this.panel2.add((Component)this.xField, "Center");
        this.border3.add((Component)this.panel1, null);
        this.panel1.add((Component)this.label3, "West");
        this.panel1.add((Component)this.yField, "Center");
        this.etchedBorder2.add((Component)this.border2, "East");
        this.border2.add((Component)this.addDatumBtn, null);
        this.border2.add((Component)this.clearSeriesBtn, null);
        this.etchedBorder2.add((Component)this.button4, "West");
        ((Container)((Object)this)).add((Component)this.graph, "Center");
    }

    public void destroy() {
        this.graph.destroy();
        super.destroy();
    }

    public void start() {
        super.start();
        this.graph.setOwner((SApplet)this);
    }

    public void stop() {
        super.stop();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Function", "String", "A function to plot."}, {"XMin", "double", "Minumum X value"}, {"XMax", "double", "Maximum X value"}, {"YMin", "double", "Minimum Y value"}, {"YMax", "double", "Maximum Y value"}, {"AutoScaleX", "boolean", "Autoscale the x axis."}, {"AutoScaleY", "boolean", "Autoscale the y axis."}, {"ShowControls", "boolean", "Show the control buttons at the bottom of the applet."}, {"DataFile", "String", "Data points file"}};
        return stringArray;
    }

    void clearSeriesBtn_actionPerformed(ActionEvent actionEvent) {
        this.clearSeries(1);
    }

    public int getGraphID() {
        return this.graph.hashCode();
    }

    public int getSeriesID(int n) {
        return this.graph.getIDFromSID(n);
    }

    public int getRegressionID(int n, int n2, int n3) {
        return this.graph.getRegressionID(n, n2, n3);
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        this.graph.addData(n, dArray, dArray2);
    }

    public void addDatum(int n, double d, double d2) {
        this.graph.addDatum(n, d, d2);
    }

    public int addCursor(double d, double d2) {
        return this.graph.addCursor((SApplet)this, 10, d, d2);
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.graph, d, d2, n, n2);
        } else if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new RectangleThing((SApplet)this, (SScalable)this.graph, d, d2, n, n2);
        } else if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new CircleThing((SApplet)this, (SScalable)this.graph, d, d2, n3);
        } else if (string.equals("cursor")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new MarkerThing((SApplet)this, (SScalable)this.graph, 2 * n3 + 1, d, d2);
        } else if (string.equals("shell")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new ShellThing((SApplet)this, (SScalable)this.graph, d, d2, n3);
        } else if (string.equals("arrow")) {
            double d3 = 1.0;
            double d4 = 1.0;
            int n4 = 4;
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d3 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d4 = SUtil.getParam((String)string2, (String)"v=");
            }
            object = new ArrowThing((SApplet)this, (SScalable)this.graph, n4, d3, d4, d, d2);
        } else if (string.equals("text")) {
            String string4 = "";
            String string5 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            object = new TextThing((SApplet)this, (SScalable)this.graph, string4, string5, d, d2);
        } else if (string.equals("caption")) {
            String string6 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            object = new CaptionThing((SApplet)this, (SScalable)this.graph, string6, d, d2);
        } else {
            if (string.equals("function")) {
                String string7 = "0";
                String string8 = "x";
                if (SUtil.parameterExist((String)string2, (String)"f=")) {
                    string7 = SUtil.getParamStr((String)string2, (String)"f=");
                }
                if (SUtil.parameterExist((String)string2, (String)"var=")) {
                    string8 = SUtil.getParamStr((String)string2, (String)"var=");
                }
                int n5 = this.addFunction(string8, string7);
                if (SUtil.parameterExist((String)string2, (String)"xmin=") && SUtil.parameterExist((String)string2, (String)"xmax=")) {
                    int n6 = 100;
                    n6 = Math.max(this.graph.getSize().width / 2, n6);
                    if (SUtil.parameterExist((String)string2, (String)"n=")) {
                        n6 = (int)SUtil.getParam((String)string2, (String)"n=");
                    }
                    double d5 = SUtil.getParam((String)string2, (String)"xmin=");
                    double d6 = SUtil.getParam((String)string2, (String)"xmax=");
                    this.graph.setFunctionRange(n5, d5, d6, n6);
                }
                return n5;
            }
            if (string.equals("image")) {
                String string9 = " ";
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                    string9 = SUtil.getParamStr((String)string2, (String)"gif=");
                }
                if (SUtil.parameterExist((String)string2, (String)"file=")) {
                    string9 = SUtil.getParamStr((String)string2, (String)"file=");
                }
                if (string9 == null) {
                    return 0;
                }
                Image image = this.getImage(string9);
                object = image != null ? new ImageThing((SApplet)this, (SScalable)this.graph, image, d, d2) : null;
            }
        }
        if (object == null) {
            System.out.println(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2)));
            return 0;
        }
        return this.graph.addThing((Thing)object);
    }

    private Image getImage(String string) {
        Serializable serializable;
        Image image;
        try {
            image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getCodeBase(), string);
        }
        catch (Exception exception) {
            image = null;
        }
        if (image == null) {
            try {
                image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getDocumentBase(), string);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            try {
                serializable = new URL(string);
                image = ((Applet)((Object)this)).getImage((URL)serializable);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            System.out.println("Failed to load image file.");
            return image;
        }
        serializable = new MediaTracker((Component)((Object)this));
        try {
            ((MediaTracker)serializable).addImage(image, 1);
            ((MediaTracker)serializable).waitForID(1, 5000L);
        }
        catch (Exception exception) {
            Image image2 = null;
            return image2;
        }
        if (((MediaTracker)serializable).isErrorAny()) {
            return null;
        }
        if (image.getHeight((ImageObserver)((Object)this)) < 1) {
            return null;
        }
        return image;
    }

    public synchronized boolean set(int n, String string, String string2) {
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        String string4 = "true";
        if (string.equals("scale")) {
            if (SUtil.parameterExist((String)string2, (String)"autoscalex")) {
                if (SUtil.parameterExist((String)string2, (String)"autoscalex=")) {
                    string4 = SUtil.getParamStr((String)string2, (String)"autoscalex=");
                }
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.graph.setAutoscaleX(false);
                } else {
                    this.graph.setAutoscaleX(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"noautoscalex")) {
                this.graph.setAutoscaleX(false);
            }
            if (SUtil.parameterExist((String)string2, (String)"autoscaley")) {
                if (SUtil.parameterExist((String)string2, (String)"autoscaley=")) {
                    string4 = SUtil.getParamStr((String)string2, (String)"autoscaley=");
                }
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.graph.setAutoscaleY(false);
                } else {
                    this.graph.setAutoscaleY(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"noautoscaley")) {
                this.graph.setAutoscaleY(false);
            }
            double d = this.graph.getMinX();
            double d2 = this.graph.getMaxX();
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d2 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmin=") || SUtil.parameterExist((String)string2, (String)"xmax=")) {
                this.graph.setMinMaxX(d, d2);
            }
            double d3 = this.graph.getMinY();
            double d4 = this.graph.getMaxY();
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d3 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d4 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=") || SUtil.parameterExist((String)string2, (String)"ymax=")) {
                this.graph.setMinMaxY(d3, d4);
            }
            return true;
        }
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2)));
            return false;
        }
        return false;
    }

    public int addFunction(String string, String string2) {
        if (string2 != null) {
            this.funcField.setText(string2);
        }
        return this.graph.addFunction(string, string2);
    }

    public void deleteFunction(int n) {
        this.graph.deleteFunction(n);
    }

    public void deleteAllFunctions() {
        this.graph.deleteAllFunctions();
    }

    public int createSeries(int n) {
        this.graph.createSeries(n);
        return this.graph.getIDFromSID(n);
    }

    public void deleteSeries(int n) {
        this.graph.deleteSeries(n);
    }

    public void deleteAllSeries() {
        this.graph.deleteAllSeries();
    }

    public void clearSeries(int n) {
        this.graph.clearSeriesData(n);
    }

    public void clearAllSeries() {
        this.graph.clearAllSeries();
    }

    public void updateDataConnections() {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            sDataConnection.clearData();
            sDataConnection.registerDatum();
        }
    }

    public void loadDataFile(int n, String string) {
        this.graph.loadFile(n, string);
    }

    public int plotRegression(int n, int n2, int n3) {
        return this.graph.plotRegression(n, n2, n3);
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(bl);
    }

    public void setAddRepeatedDatum(int n, boolean bl) {
        this.graph.setAddRepeatedDatum(n, bl);
    }

    public void setAutoscaleX(boolean bl) {
        this.graph.setAutoscaleX(bl);
    }

    public void setAutoscaleY(boolean bl) {
        this.graph.setAutoscaleY(bl);
    }

    public void setDrawGrid(boolean bl) {
        this.graph.setDrawGrid(bl);
    }

    public void setDrawZero(boolean bl) {
        this.graph.setDrawZero(bl);
    }

    public void setDefault() {
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.graph.setTimeDisplay(false);
        this.clock.removeClockListener((SStepable)this.graph);
        this.graph.deleteAllSeries();
        this.graph.deleteAllFunctions();
        this.graph.clearAllThings();
        this.deleteDataConnections();
    }

    public boolean setVisibility(int n, boolean bl) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        return true;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
        return true;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    public int setSketchMode(boolean bl) {
        return this.graph.setSketchMode(bl);
    }

    public void setEnableMouse(boolean bl) {
        this.graph.setEnableMouse(bl);
    }

    public void setFunctionRange(int n, double d, double d2, int n2) {
        this.graph.setFunctionRange(n, d, d2, n2);
    }

    public void setYScaleFromFunction(int n) {
        this.graph.setYScaleFromFunction(n);
    }

    public boolean setFunctionString(int n, String string) {
        if (string != null) {
            this.funcField.setText(string);
        }
        return this.graph.setFunctionString(n, string);
    }

    public String getFunctionString(int n) {
        return this.graph.getFunctionString(n);
    }

    public boolean setFunctionVariable(int n, String string) {
        return this.graph.setFunctionVariable(n, string);
    }

    public synchronized void setGutters(int n, int n2, int n3, int n4) {
        this.graph.setGutters(n, n2, n3, n4);
    }

    public void setFormat(String string) {
        this.graph.setFormat(string);
    }

    public boolean setFormat(int n, String string) {
        Thing thing = this.graph.getThing(n);
        if (thing == null && (n == 0 || n == this.graph.hashCode())) {
            this.graph.setFormat(string);
            return true;
        }
        boolean bl = thing.setFormat(string);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
        return bl;
    }

    public void setLabelX(String string) {
        this.graph.setLabelX(string);
    }

    public void setLabelY(String string) {
        this.graph.setLabelY(string);
    }

    public void setMarkerSize(int n, double d) {
        this.graph.setMarkerSize(n, d);
    }

    public void setMinMaxX(double d, double d2) {
        this.graph.setMinMaxX(d, d2);
    }

    public void setMinMaxY(double d, double d2) {
        this.graph.setMinMaxY(d, d2);
    }

    public void setMinXRange(boolean bl, double d, double d2) {
        this.graph.setMinXRange(bl, d, d2);
    }

    public void setMinYRange(boolean bl, double d, double d2) {
        this.graph.setMinYRange(bl, d, d2);
    }

    public synchronized void setSeriesLegend(int n, int n2, int n3, String string) {
        this.graph.setSeriesLegend(n, n2, n3, string);
    }

    public synchronized void setSeriesLegendRGB(int n, int n2, int n3, int n4) {
        this.graph.setSeriesLegendColor(n, new Color(n2, n3, n4));
    }

    public synchronized void setSeriesStyle(int n, boolean bl, int n2) {
        this.graph.setSeriesStyle(n, bl, n2);
    }

    public synchronized void setSeriesRGB(int n, int n2, int n3, int n4) {
        this.graph.setSeriesColor(n, new Color(n2, n3, n4));
    }

    public synchronized void setRGB(int n, int n2, int n3, int n4) {
        Color color = new Color(n2, n3, n4);
        this.graph.setObjectColor(n, color);
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        this.graph.setAutoReplaceData(n, bl);
    }

    public synchronized void setLastPointMarker(int n, boolean bl) {
        this.graph.setLastPointMarker(n, bl);
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setTimeDisplay(boolean bl) {
        this.graph.setTimeDisplay(bl);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
    }

    public synchronized void setShowAxes(boolean bl) {
        if (this.graph.isShowAxis() == bl) {
            return;
        }
        if (bl) {
            this.graph.setGutters(20, 20, 20, 20);
            this.graph.drawgrid = true;
        } else {
            this.graph.setGutters(0, 0, 0, 0);
            this.graph.drawgrid = false;
        }
        this.graph.setShowAxes(bl);
    }

    public synchronized void setSquare(boolean bl) {
        this.graph.setSquare(bl);
    }

    public synchronized void setSorted(int n, boolean bl) {
        this.graph.setSeriesSorted(n, bl);
    }

    void addFuncBtn_actionPerformed(ActionEvent actionEvent) {
        this.graph.deleteAllFunctions();
        this.addFunction("x", this.funcField.getText());
    }

    void addDatumBtn_actionPerformed(ActionEvent actionEvent) {
        this.addDatum(1, this.xField.getValue(), this.yField.getValue());
    }

    void button4_actionPerformed(ActionEvent actionEvent) {
        this.graph.clearAllData();
    }

    void clearFuncBtn_actionPerformed(ActionEvent actionEvent) {
        this.graph.deleteAllFunctions();
    }
}

