/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.display.Format;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;
import molecular.EnsemblePanel;
import molecular.Ensemble_mouseAdapter;
import molecular.Ensemble_mouseMotionAdapter;

public class Ensemble
implements SStepable,
SDataSource {
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private boolean enableMouse = false;
    private int boxWidth = 0;
    private Format mouseFormat = new Format("%-+6.3g");
    private int mouseX = 0;
    private int mouseY = 0;
    boolean mouseDown = false;
    Vector ensembleDataSources = new Vector();
    String message = null;
    boolean showMessage = false;
    int bwidth = 5;
    double xOrigin = 0.0;
    double yOrigin = 0.0;
    int skipCounter = 0;
    int skip = 0;
    String[] varStrings = new String[]{"time", "p", "v", "t", "n", "qt", "qr", "qb", "ql", "pt", "pr", "pb", "pl", "dv", "dt"};
    double[][] ds = new double[1][15];
    Color bgColor = Color.green;
    boolean autoRefresh = true;
    boolean setup;
    boolean running;
    double qt = 0.0;
    double qb = 0.0;
    double qr = 0.0;
    double ql = 0.0;
    double pt = 0.0;
    double pb = 0.0;
    double pr = 0.0;
    double pl = 0.0;
    double dv = 0.0;
    double mint;
    double kb = 1.0;
    double dmass = 1.0;
    double dtemp = 0.0;
    double dsize = 1.0;
    Color dcolor = new Color(0, 0, 150);
    int maxp = 80;
    int mode = 0;
    int ppu = 10;
    double time = 0.0;
    double[] xOff = new double[8];
    double[] yOff = new double[8];
    double rwpos = 10.0;
    double lwpos = 0.0;
    double twpos = 10.0;
    double bwpos = 0.0;
    int nump = 20;
    double temptime = -1.0;
    double[][] colTimes = null;
    double[] rwColTimes = null;
    double[] lwColTimes = null;
    double[] twColTimes = null;
    double[] bwColTimes = null;
    double[] xVel = null;
    double[] yVel = null;
    double[] xPos = null;
    double[] yPos = null;
    double[] mass = null;
    double[] rad = null;
    double k = 0.0;
    Color forrest = new Color(0, 120, 0);
    Color brown = new Color(190, 110, 0);
    Color navy = new Color(0, 0, 150);
    Color purple = new Color(100, 0, 135);
    Color[] colors = null;
    Color[] colors2 = new Color[]{Color.white, Color.red, Color.pink, this.navy, Color.orange, Color.lightGray, Color.yellow, Color.magenta, this.forrest, Color.darkGray, this.brown, this.purple, Color.blue, Color.cyan, Color.black};
    int lastpartnum = -1;
    int sleeptime = 50;
    int nColliding1 = 0;
    int nColliding2 = 0;
    int nCollidingW = 1;
    int nCollidingN = 0;
    int nCollidingI = 0;
    boolean periodicv = true;
    boolean periodich = true;
    boolean periodic = true;
    boolean colPart;
    boolean change = true;
    Ensemble[] neighbor = new Ensemble[8];
    double[] wallTemps = new double[4];
    boolean[] therms = new boolean[]{false, false, false, false};
    double pvolume = 0.0;
    boolean keepRunning;
    boolean[] empty = null;
    boolean[] image = null;
    double[] imageTimes = new double[8];
    double[] imageTimes2 = new double[8];
    EnsemblePanel owner = null;
    SApplet applet = null;
    Histogram histogram = null;

    public Ensemble() {
    }

    public Ensemble(EnsemblePanel ensemblePanel) {
        this();
        this.owner = ensemblePanel;
        this.applet = this.owner.owner;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void start() {
    }

    public void stop() {
    }

    public void setBounds() {
        this.owner.currentw = this.owner.getSize().width;
        this.owner.currenth = this.owner.getSize().height;
        if (!this.periodich) {
            this.setRWPos((double)(this.owner.currentw - 2 * this.bwidth) / (double)this.ppu);
        } else {
            this.setRWPos((double)this.owner.currentw / (double)this.ppu);
        }
        this.setLWPos(0.0);
        if (!this.periodicv) {
            this.setTWPos((double)(this.owner.currenth - 2 * this.bwidth) / (double)this.ppu);
        } else {
            this.setTWPos((double)this.owner.currenth / (double)this.ppu);
        }
        this.setBWPos(0.0);
        this.xOrigin = (this.rwpos + this.lwpos) / (double)2;
        this.yOrigin = (this.twpos + this.bwpos) / (double)2;
        if (this.periodicv) {
            this.setNeighbor(1, this, 0.0, this.twpos);
            this.setNeighbor(5, this, 0.0, -this.twpos);
        }
        if (this.periodich) {
            this.setNeighbor(3, this, this.rwpos, 0.0);
            this.setNeighbor(7, this, -this.rwpos, 0.0);
        }
        if (this.periodich || this.periodicv) {
            this.setNeighbor(0, this, -this.rwpos, this.twpos);
            this.setNeighbor(2, this, this.rwpos, this.twpos);
            this.setNeighbor(4, this, this.rwpos, -this.twpos);
            this.setNeighbor(6, this, -this.rwpos, -this.twpos);
        }
        this.owner.makeImage();
    }

    void initializeArrays() {
        int n;
        if (this.maxp <= 0) {
            this.maxp = 50;
        }
        this.colTimes = new double[this.maxp][];
        for (n = 0; n < this.maxp; ++n) {
            this.colTimes[n] = new double[n + 1];
        }
        this.rwColTimes = new double[this.maxp];
        this.lwColTimes = new double[this.maxp];
        this.twColTimes = new double[this.maxp];
        this.bwColTimes = new double[this.maxp];
        this.xVel = new double[this.maxp];
        this.yVel = new double[this.maxp];
        this.xPos = new double[this.maxp];
        this.yPos = new double[this.maxp];
        this.mass = new double[this.maxp];
        this.rad = new double[this.maxp];
        this.colors = new Color[this.maxp];
        this.empty = new boolean[this.maxp];
        for (n = 0; n < this.maxp; ++n) {
            this.empty[n] = true;
        }
        this.lastpartnum = -1;
    }

    void clearPressureCounters() {
        this.qt = 0.0;
        this.qr = 0.0;
        this.qb = 0.0;
        this.ql = 0.0;
        this.pr = 0.0;
        this.pl = 0.0;
        this.pt = 0.0;
        this.pb = 0.0;
    }

    void adjustPressureCounters(double d) {
        this.pr /= d;
        this.pl /= d;
        this.pt /= d;
        this.pb /= d;
    }

    public void step(double d, double d2) {
        this.qt = 0.0;
        this.qr = 0.0;
        this.qb = 0.0;
        this.ql = 0.0;
        this.pr = 0.0;
        this.pl = 0.0;
        this.pt = 0.0;
        this.pb = 0.0;
        double d3 = d;
        do {
            if (d3 < this.mint) {
                this.mint -= d3;
                d3 -= this.advanceDT(d3);
                continue;
            }
            d3 -= this.advanceDT(this.mint);
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                int n = i;
                this.rwColTimes[n] = this.rwColTimes[n] - this.temptime;
                int n2 = i;
                this.lwColTimes[n2] = this.lwColTimes[n2] - this.temptime;
                int n3 = i;
                this.twColTimes[n3] = this.twColTimes[n3] - this.temptime;
                int n4 = i;
                this.bwColTimes[n4] = this.bwColTimes[n4] - this.temptime;
            }
            for (int i = 1; i < this.lastpartnum + 1; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.empty[i] || this.empty[j]) continue;
                    double[] dArray = this.colTimes[i];
                    int n = j;
                    dArray[n] = dArray[n] - this.temptime;
                }
            }
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles(this.nColliding1, this.nColliding2);
                    break;
                }
                case 1: {
                    this.collideTW(this.nColliding1);
                    break;
                }
                case 2: {
                    this.collideRW(this.nColliding1);
                    break;
                }
                case 3: {
                    this.collideBW(this.nColliding1);
                    break;
                }
                case 4: {
                    this.collideLW(this.nColliding1);
                }
            }
            this.findMinColTime();
        } while (d3 > 0.0);
        this.paintOSI();
        Graphics graphics = this.owner.getGraphics();
        this.owner.paint(graphics);
        graphics.dispose();
        this.time = d2 + d;
        this.pr /= d;
        this.pl /= d;
        this.pt /= d;
        this.pb /= d;
        if (this.applet != null) {
            if (this.histogram != null) {
                this.applet.clearData(this.histogram.hashCode());
            }
            this.applet.updateDataConnections();
        }
    }

    public double advanceDT(double d) {
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            int n = i;
            this.xPos[n] = this.xPos[n] + d * this.xVel[i];
            int n2 = i;
            this.yPos[n2] = this.yPos[n2] + d * this.yVel[i];
        }
        this.time += d;
        return d;
    }

    public double calcColTimeTW(int n) {
        if (this.empty[n]) {
            return 10000.0;
        }
        if (this.yVel[n] > 0.0) {
            if (this.neighbor[1] == null) {
                return Math.max(0.0, (this.twpos - this.rad[n] - this.yPos[n]) / this.yVel[n]);
            }
            if (this.yPos[n] < this.twpos) {
                return Math.max(0.0, (this.twpos - this.yPos[n]) / this.yVel[n]);
            }
        }
        return 10000.0;
    }

    public double calcColTimeLW(int n) {
        if (this.empty[n]) {
            return 10000.0;
        }
        if (this.xVel[n] < 0.0) {
            if (this.neighbor[7] == null) {
                return Math.max(0.0, (this.lwpos + this.rad[n] - this.xPos[n]) / this.xVel[n]);
            }
            if (this.xPos[n] > this.lwpos) {
                return Math.max(0.0, (this.lwpos - this.xPos[n]) / this.xVel[n]);
            }
        }
        return 10000.0;
    }

    public double calcColTimeBW(int n) {
        if (this.empty[n]) {
            return 10000.0;
        }
        if (this.yVel[n] < 0.0) {
            if (this.neighbor[5] == null) {
                return Math.max(0.0, (this.bwpos + this.rad[n] - this.yPos[n]) / this.yVel[n]);
            }
            if (this.yPos[n] > this.bwpos) {
                return Math.max(0.0, (this.bwpos - this.yPos[n]) / this.yVel[n]);
            }
        }
        return 10000.0;
    }

    public double calcColTimeRW(int n) {
        if (this.empty[n]) {
            return 10000.0;
        }
        if (this.xVel[n] > 0.0) {
            if (this.neighbor[3] == null) {
                return Math.max(0.0, (this.rwpos - this.rad[n] - this.xPos[n]) / this.xVel[n]);
            }
            if (this.xPos[n] < this.rwpos) {
                return Math.max(0.0, (this.rwpos - this.xPos[n]) / this.xVel[n]);
            }
        }
        return 10000.0;
    }

    public double getColTime(int n, int n2) {
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        return this.colTimes[n3][n4];
    }

    public double calcColTime(int n, int n2) {
        if (this.empty[n] || this.empty[n2]) {
            return 10000.0;
        }
        double d = 10000.0;
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        double d2 = this.xVel[n3] - this.xVel[n4];
        double d3 = this.yVel[n3] - this.yVel[n4];
        double d4 = this.yPos[n3] - this.yPos[n4];
        double d5 = this.xPos[n3] - this.xPos[n4];
        if (Math.sqrt(d4 * d4 + d5 * d5) < this.rad[n3] + this.rad[n4] - 0.001) {
            return 10000.0;
        }
        double d6 = d2 * d5 + d3 * d4;
        if (d6 >= 0.0) {
            d = 10000.0;
        } else {
            double d7 = d2 * d2 + d3 * d3;
            double d8 = d5 * d5 + d4 * d4;
            double d9 = (this.rad[n3] + this.rad[n4]) * (this.rad[n3] + this.rad[n4]);
            double d10 = d6 * d6 - d7 * (d8 - d9);
            if (d10 < 0.0) {
                d = 10000.0;
            } else {
                double d11 = (-d6 - Math.sqrt(d10)) / d7;
                d = Math.max(0.0, d11);
                return d;
            }
        }
        d = Math.min(d, this.calcImageCollisionTime(n, n2));
        return d;
    }

    public double calcImageCollisionTime(int n, int n2) {
        double d = 10000.0;
        if (this.empty[n] || this.empty[n2]) {
            return 10000.0;
        }
        Ensemble ensemble = null;
        for (int i = 0; i < 8; ++i) {
            ensemble = this.neighbor[i];
            if (ensemble == null || ensemble != this) continue;
            d = Math.min(d, this.calcColTimeIm(n, n2, i, this.xOff[i], this.yOff[i]));
        }
        return Math.max(0.0, d);
    }

    public double calcColTimeIm(int n, int n2, int n3, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        Ensemble ensemble = this.neighbor[n3];
        double d8 = ensemble.xPos[n2] + d;
        double d9 = ensemble.yPos[n2] + d2;
        double d10 = ensemble.xVel[n2];
        double d11 = ensemble.yVel[n2];
        double d12 = ensemble.rad[n2];
        double d13 = this.xVel[n] - d10;
        double d14 = this.xPos[n] - d8;
        double d15 = this.yVel[n] - d11;
        double d16 = this.yPos[n] - d9;
        double d17 = d13 * d14 + d15 * d16;
        double d18 = d17 >= 0.0 ? 10000.0 : ((d7 = d17 * d17 - (d6 = d13 * d13 + d15 * d15) * ((d5 = d14 * d14 + d16 * d16) - (d4 = (this.rad[n] + d12) * (this.rad[n] + d12)))) < 0.0 ? 10000.0 : (d3 = (-d17 - Math.sqrt(d7)) / d6));
        return Math.max(0.0, d18);
    }

    public void collideParticles(int n, int n2) {
        int n3;
        int n4 = Math.max(n, n2);
        int n5 = Math.min(n, n2);
        if (this.empty[n4] || this.empty[n5]) {
            return;
        }
        if (this.mass[n4] != this.mass[n5]) {
            this.collideDiffMassParticles(n4, n5);
        } else {
            double d = this.rad[n] + this.rad[n2];
            double d2 = this.xVel[n4] - this.xVel[n5];
            double d3 = this.yVel[n4] - this.yVel[n5];
            double d4 = this.xPos[n5] - this.xPos[n4];
            double d5 = this.yPos[n5] - this.yPos[n4];
            if (d4 > d) {
                d4 -= this.rwpos - this.lwpos;
            }
            if (d5 > d) {
                d5 -= this.twpos;
            }
            if (d4 < -d) {
                d4 += this.rwpos - this.lwpos;
            }
            if (d5 < -d) {
                d5 += this.twpos;
            }
            double d6 = d4 * d4 + d5 * d5;
            double d7 = d2 * d4 + d3 * d5;
            this.xVel[n4] = this.xVel[n4] - d7 * d4 / d6;
            this.yVel[n4] = this.yVel[n4] - d7 * d5 / d6;
            this.xVel[n5] = this.xVel[n5] + d7 * d4 / d6;
            this.yVel[n5] = this.yVel[n5] + d7 * d5 / d6;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.colTimes[n4][n3] = this.calcColTime(n4, n3);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            this.colTimes[n5][n3] = this.calcColTime(n5, n3);
        }
        for (n3 = n5 + 1; n3 < this.lastpartnum + 1; ++n3) {
            this.colTimes[n3][n5] = this.calcColTime(n3, n5);
        }
        for (n3 = n4 + 1; n3 < this.lastpartnum + 1; ++n3) {
            this.colTimes[n3][n4] = this.calcColTime(n3, n4);
        }
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        this.bwColTimes[n2] = this.calcColTimeBW(n2);
        this.lwColTimes[n2] = this.calcColTimeLW(n2);
        this.rwColTimes[n2] = this.calcColTimeRW(n2);
        this.twColTimes[n2] = this.calcColTimeTW(n2);
    }

    public void collideDiffMassParticles(int n, int n2) {
        double d = this.rad[n] + this.rad[n2];
        double d2 = this.mass[n];
        double d3 = this.mass[n2];
        double d4 = this.xPos[n];
        double d5 = this.xPos[n2];
        double d6 = this.xPos[n] - this.xPos[n2];
        double d7 = this.yPos[n] - this.yPos[n2];
        double d8 = this.xVel[n];
        double d9 = this.xVel[n2];
        double d10 = this.yVel[n];
        double d11 = this.yVel[n2];
        double d12 = (d2 * d8 + d3 * d9) / (d2 + d3);
        double d13 = (d2 * d10 + d3 * d11) / (d2 + d3);
        d8 -= d12;
        d10 -= d13;
        d9 -= d12;
        d11 -= d13;
        if (d6 > d + 0.1) {
            d6 -= this.rwpos - this.lwpos;
        }
        if (d7 > d + 0.1) {
            d7 -= this.twpos;
        }
        if (d6 < -d - 0.1) {
            d6 += this.rwpos - this.lwpos;
        }
        if (d7 < -d - 0.1) {
            d7 += this.twpos;
        }
        double d14 = d6 / d;
        double d15 = d7 / d;
        double d16 = -d14;
        double d17 = -d15;
        double d18 = Math.abs(d14 * d8 + d15 * d10);
        double d19 = Math.abs(d16 * d9 + d17 * d11);
        int n3 = n;
        this.xVel[n3] = this.xVel[n3] + (double)2 * d18 * d14;
        int n4 = n;
        this.yVel[n4] = this.yVel[n4] + (double)2 * d18 * d15;
        int n5 = n2;
        this.xVel[n5] = this.xVel[n5] + (double)2 * d19 * d16;
        int n6 = n2;
        this.yVel[n6] = this.yVel[n6] + (double)2 * d19 * d17;
    }

    public void collideTW(int n) {
        int n2;
        if (this.empty[n]) {
            return;
        }
        this.pt += Math.abs(this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        if (this.neighbor[1] != null) {
            this.yPos[n] = this.bwpos;
        } else if (this.therms[0]) {
            this.thermalize(n, 0);
        } else {
            this.yVel[n] = -this.yVel[n];
        }
        this.pt += Math.abs(-this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
    }

    public void collideBW(int n) {
        int n2;
        if (this.empty[n]) {
            return;
        }
        this.pb += Math.abs(this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        if (this.neighbor[5] != null) {
            this.yPos[n] = this.twpos;
        } else if (this.therms[2]) {
            this.thermalize(n, 2);
        } else {
            this.yVel[n] = -this.yVel[n];
        }
        this.pb += Math.abs(-this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
    }

    public void collideLW(int n) {
        int n2;
        if (this.empty[n]) {
            return;
        }
        this.pl += Math.abs(this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        if (this.neighbor[7] != null) {
            this.xPos[n] = this.rwpos;
        } else if (this.therms[3]) {
            this.thermalize(n, 3);
        } else {
            this.xVel[n] = -this.xVel[n];
        }
        this.pl += Math.abs(-this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
    }

    public void collideRW(int n) {
        int n2;
        if (this.empty[n]) {
            return;
        }
        this.pr += Math.abs(this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        if (this.neighbor[3] != null) {
            this.xPos[n] = this.lwpos;
        } else if (this.therms[1]) {
            this.thermalize(n, 1);
        } else {
            this.xVel[n] = -this.xVel[n];
        }
        this.pr += Math.abs(-this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
    }

    private void switchVelocity(int n) {
        int n2;
        int n3;
        int n4 = 0;
        while (this.empty[n3 = (int)Math.floor((double)this.lastpartnum * Math.random())] && ++n4 < 2 * this.lastpartnum) {
        }
        if (this.empty[n3]) {
            System.out.println("Error: Cannot find non-empty particle. No particle switch.");
            return;
        }
        double d = this.xVel[n];
        double d2 = this.yVel[n];
        this.xVel[n] = this.xVel[n3];
        this.yVel[n] = this.yVel[n3];
        this.xVel[n3] = d;
        this.xVel[n3] = d2;
        this.bwColTimes[n3] = this.calcColTimeBW(n3);
        this.lwColTimes[n3] = this.calcColTimeLW(n3);
        this.rwColTimes[n3] = this.calcColTimeRW(n3);
        this.twColTimes[n3] = this.calcColTimeTW(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.colTimes[n3][n2] = this.calcColTime(n3, n2);
        }
        for (n2 = n3 + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n3] = this.calcColTime(n2, n3);
        }
    }

    public void thermalize(int n, int n2) {
        if (n < 0 || n >= this.maxp || this.mass[n] <= 0.0) {
            System.out.println("Error in thermalize: mass=0?");
            return;
        }
        double d = this.wallTemps[n2];
        this.switchVelocity(n);
        double d2 = Math.sqrt(this.xVel[n] * this.xVel[n] + this.yVel[n] * this.yVel[n]);
        double d3 = Math.sqrt((double)2 * this.kb * d / this.mass[n]);
        if (n2 == 0) {
            this.yVel[n] = -d3 * Math.random();
            if (Math.random() < 0.5) {
                this.xVel[n] = Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            }
            this.xVel[n] = -Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            this.qt += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 1) {
            this.xVel[n] = -d3 * Math.random();
            this.yVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]) : -Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]);
            this.qr += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 2) {
            this.yVel[n] = d3 * Math.random();
            this.xVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]) : -Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            this.qb += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 3) {
            this.xVel[n] = d3 * Math.random();
            this.yVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]) : -Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]);
            this.ql += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        }
    }

    public void findMinColTime() {
        if (this.empty == null) {
            return;
        }
        double d = this.applet.clock.getDt();
        double d2 = 10000.0;
        double d3 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d2) {
                d2 = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
            }
            if (this.rwColTimes[0] < d2) {
                d2 = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
            }
            if (this.bwColTimes[0] < d2) {
                d2 = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
            }
            if (this.lwColTimes[0] < d2) {
                d2 = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d2) {
                d2 = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
            }
            if (this.rwColTimes[i] < d2) {
                d2 = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
            }
            if (this.bwColTimes[i] < d2) {
                d2 = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
            }
            if (this.lwColTimes[i] < d2) {
                d2 = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
            }
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d2)) continue;
                d2 = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
            }
        }
        this.temptime = this.mint = d2;
    }

    void setNeighbor(int n, Ensemble ensemble, double d, double d2) {
        this.neighbor[n] = ensemble;
        this.xOff[n] = d;
        this.yOff[n] = d2;
    }

    public boolean setParticleSize(int n, double d) {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        if (n < 0 || this.rad == null || n > this.rad.length - 1) {
            System.out.println(String.valueOf("Error in setParticleSize. Particle index out or range:").concat(String.valueOf(n)));
            return false;
        }
        if ((d = Math.abs(d)) + 0.001 > (this.rwpos - this.lwpos) / (double)2) {
            d = 2.0;
        }
        if (this.xPos[n] + d > this.rwpos) {
            System.out.println(String.valueOf("Error in setParticleSize:").concat(String.valueOf(d)));
            d = this.rwpos - 0.01 - this.xPos[n];
        }
        if (this.xPos[n] - d < this.lwpos) {
            System.out.println(String.valueOf("Error in setParticleSize:").concat(String.valueOf(d)));
            d = this.xPos[n] - this.lwpos - 0.01;
        }
        if (this.yPos[n] + d > this.twpos) {
            System.out.println(String.valueOf("Error in setParticleSize:").concat(String.valueOf(d)));
            d = this.twpos - 0.01 - this.yPos[n];
        }
        if (this.yPos[n] - d < this.bwpos) {
            System.out.println(String.valueOf("Error in setParticleSize:").concat(String.valueOf(d)));
            d = this.yPos[n] - this.bwpos - 0.01;
        }
        this.rad[n] = d;
        if (this.autoRefresh) {
            int n2;
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
            this.findMinColTime();
        }
        if (bl) {
            this.forward();
        }
        return true;
    }

    public void setParticleMass(int n, double d) {
        if (n < this.mass.length && d > 0.0) {
            this.mass[n] = d;
        } else {
            System.out.println(String.valueOf(String.valueOf("Error in setParticleMass. Particle index out or range:").concat(String.valueOf(n))).concat(String.valueOf("or mass<=0")));
        }
    }

    void setParticle(int n, double d, double d2, double d3, double d4, double d5) {
        if (this.xVel == null || this.owner.osi == null) {
            this.setBounds();
        }
        if (this.xPos == null) {
            this.initializeArrays();
        }
        if (n < this.xVel.length && this.xVel != null) {
            int n2;
            this.lastpartnum = Math.max(n, this.lastpartnum);
            if (d5 + 0.001 > (this.rwpos + this.lwpos) / (double)2) {
                d5 = 2.0;
            }
            this.rad[n] = d5;
            if (this.periodich && (d + this.rad[n] > this.rwpos || d - this.rad[n] < this.lwpos)) {
                d = (this.rwpos + this.lwpos) / (double)2;
                this.rad[n] = Math.min(this.rad[n], this.rwpos - d - 0.01);
            }
            if (this.periodicv && (d2 + this.rad[n] > this.twpos || d2 - this.rad[n] < this.bwpos)) {
                d2 = (this.twpos + this.bwpos) / (double)2;
                this.rad[n] = Math.min(this.rad[n], this.twpos - d2 - 0.01);
            }
            this.xPos[n] = d;
            this.yPos[n] = d2;
            this.xVel[n] = d3;
            this.yVel[n] = d4;
            this.empty[n] = false;
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            this.bwColTimes[n] = this.calcColTimeBW(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
            this.mass[n] = this.dmass;
            this.colors[n] = this.dcolor;
        } else {
            System.out.println(String.valueOf("Error in setParticle. Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    public synchronized int addParticle(double d, double d2, double d3, double d4, double d5) {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        if (this.xVel == null || this.owner.osi == null) {
            this.setBounds();
        }
        if (this.xPos == null) {
            this.initializeArrays();
        }
        int n = this.findEmptyPart();
        d += (this.rwpos + this.lwpos) / (double)2;
        d2 += (this.twpos + this.bwpos) / (double)2;
        if (n < this.maxp && n >= 0) {
            this.setParticle(n, d, d2, d3, d4, d5);
        } else {
            System.out.println(String.valueOf("Error in addParticle. Particle index out or range:").concat(String.valueOf(n)));
        }
        if (this.autoRefresh) {
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
        }
        this.pvolume += Math.PI * d5 * d5;
        if (bl) {
            this.forward();
        }
        return n;
    }

    int findEmptyPart() {
        int n;
        for (n = 0; n < this.lastpartnum + 1 && !this.empty[n]; ++n) {
        }
        if (n > this.lastpartnum) {
            if (n < this.maxp) {
                return n;
            }
            return 0;
        }
        if (this.empty[n]) {
            return n;
        }
        return 0;
    }

    public void setParticlePos(int n, double d, double d2) {
        if (n < this.xPos.length && n >= 0) {
            d2 += this.yOrigin;
            if ((d += this.xOrigin) + this.rad[n] > this.rwpos || d - this.rad[n] < this.lwpos) {
                System.out.println(String.valueOf("Error in setParticlePos:X").concat(String.valueOf(d -= this.xOrigin)));
                d = this.xOrigin;
            }
            if (d2 + this.rad[n] > this.twpos || d2 - this.rad[n] < this.bwpos) {
                System.out.println(String.valueOf("Error in setParticlePos:Y").concat(String.valueOf(d2 -= this.yOrigin)));
                d2 = this.yOrigin;
            }
            this.xPos[n] = d;
            this.yPos[n] = d2;
            if (this.autoRefresh) {
                int n2;
                this.rwColTimes[n] = this.calcColTimeRW(n);
                this.lwColTimes[n] = this.calcColTimeLW(n);
                this.twColTimes[n] = this.calcColTimeTW(n);
                this.bwColTimes[n] = this.calcColTimeBW(n);
                for (n2 = 0; n2 < n; ++n2) {
                    this.colTimes[n][n2] = this.calcColTime(n, n2);
                }
                for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                    this.colTimes[n2][n] = this.calcColTime(n2, n);
                }
                this.findMinColTime();
            }
        } else {
            System.out.println(String.valueOf("Error in setParticlePos. Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    public void setParticleVel(int n, double d, double d2) {
        if (n < this.xVel.length && n >= 0) {
            this.xVel[n] = d;
            this.yVel[n] = d2;
            if (this.autoRefresh) {
                this.recalculateColTimes(n);
            }
        } else {
            System.out.println(String.valueOf("Error in setParticleVel(). Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    public void setParticleRGB(int n, int n2, int n3, int n4) {
        if (n < this.colors.length && n >= 0) {
            this.colors[n] = new Color(n2, n3, n4);
        } else {
            System.out.println(String.valueOf("Error in setParticleRGB. Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    public void setTemperature(double d, int n) {
        if (n < 1) {
            this.setTemp(d);
            return;
        }
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        double d2 = this.getTemp();
        double d3 = (d - d2) / (double)n;
        for (int i = 0; i < n; ++i) {
            this.setTemp(d2 += d3);
            if (this.histogram != null) {
                this.applet.clearData(this.histogram.hashCode());
            }
            if (this.applet != null) {
                this.applet.updateDataConnections();
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.forward();
        }
    }

    public void setTemp(double d) {
        if (d <= 0.0) {
            return;
        }
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        int n = this.getNumParticles();
        double d2 = 0.0;
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            d2 += this.mass[i];
        }
        double d3 = Math.sqrt((double)(2 * n) * d / d2);
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (Math.random() > 0.5) {
                this.yVel[i] = -d3 * Math.random();
                if (Math.random() < 0.5) {
                    this.xVel[i] = Math.sqrt(d3 * d3 - this.yVel[i] * this.yVel[i]);
                    continue;
                }
                this.xVel[i] = -Math.sqrt(d3 * d3 - this.yVel[i] * this.yVel[i]);
                continue;
            }
            this.yVel[i] = d3 * Math.random();
            this.xVel[i] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.yVel[i] * this.yVel[i]) : -Math.sqrt(d3 * d3 - this.yVel[i] * this.yVel[i]);
        }
        this.recalculateColTimes();
        if (bl) {
            this.forward();
        }
    }

    public void changeToTemp(double d) {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            this.pause();
        }
        double d2 = this.getTemp();
        double d3 = d2 / d;
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            this.xVel[i] = this.xVel[i] / Math.sqrt(d3);
            this.yVel[i] = this.yVel[i] / Math.sqrt(d3);
        }
        double d4 = this.getTemp();
        this.recalculateColTimes();
        if (bl) {
            this.forward();
        }
    }

    public synchronized void setBackgroundRGB(int n, int n2, int n3) {
        this.bgColor = new Color(n, n2, n3);
        if (this.autoRefresh) {
            this.paintOSI();
        }
    }

    public void recalculateColTimes(int n) {
        int n2;
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        for (n2 = 0; n2 < n; ++n2) {
            if (this.empty[n2]) continue;
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            if (this.empty[n2]) continue;
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
        this.findMinColTime();
    }

    public void recalculateColTimes() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.lastpartnum + 1; ++n2) {
            if (this.empty[n2]) continue;
            n = n2;
            this.rwColTimes[n2] = this.calcColTimeRW(n2);
            this.lwColTimes[n2] = this.calcColTimeLW(n2);
            this.twColTimes[n2] = this.calcColTimeTW(n2);
            this.bwColTimes[n2] = this.calcColTimeBW(n2);
        }
        for (n2 = 1; n2 < this.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.empty[n] || this.empty[n2]) continue;
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
        this.findMinColTime();
    }

    public synchronized void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.applet.clock.isRunning()) {
                bl2 = true;
                this.pause();
            }
            this.setBounds();
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
            if (bl2) {
                this.forward();
            }
        }
    }

    public void removeParticle(int n) {
        if (n < this.lastpartnum + 1 && n >= 0) {
            this.clearColTimes(n);
            --this.nump;
            this.pvolume -= this.rad[n] * this.rad[n] * Math.PI;
        } else {
            System.out.println(String.valueOf("Error in removeParticle. Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    void removeParticles(int n) {
        if (n < this.lastpartnum + 1 && n >= 0) {
            for (int i = 0; i < n + 1 && i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                this.clearColTimes(i);
                --this.nump;
                this.pvolume -= this.rad[i] * this.rad[i] * Math.PI;
            }
            this.lastpartnum -= n;
        }
    }

    void clearColTimes(int n) {
        if (n >= 0 && n < this.empty.length) {
            int n2;
            this.empty[n] = true;
            this.twColTimes[n] = 10000.0;
            this.rwColTimes[n] = 10000.0;
            this.bwColTimes[n] = 10000.0;
            this.lwColTimes[n] = 10000.0;
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = 10000.0;
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = 10000.0;
            }
        }
    }

    public void setParticles(int n) {
        int n2 = this.getNumParticles();
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        if (n > 0) {
            if (n > n2) {
                this.createParticles(n - n2);
            } else if (n < n2) {
                this.removeParticles(n2 - n);
            }
        }
        if (bl) {
            this.forward();
        }
    }

    public double calcKE() {
        double d = 0.0;
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            double d2 = this.xVel[i] * this.xVel[i] + this.yVel[i] * this.yVel[i];
            d += 0.5 * this.mass[i] * d2;
        }
        return d;
    }

    public double calcTemp() {
        int n = this.getNumParticles();
        if (n > 0) {
            return this.calcKE() / ((double)n * this.kb);
        }
        return 1.0;
    }

    public synchronized void paintOSI() {
        int n;
        int n2 = 10;
        int n3 = 10;
        int n4 = this.owner.currentw;
        int n5 = this.owner.currenth;
        if (this.owner.osi == null) {
            return;
        }
        if (this.periodich) {
            if (this.periodicv) {
                n2 = 0;
                n3 = 0;
            } else {
                n2 = this.bwidth;
            }
            n3 = 0;
        } else if (this.periodicv) {
            n3 = this.bwidth;
            n2 = 0;
        } else {
            n3 = this.bwidth;
            n2 = this.bwidth;
        }
        Graphics graphics = this.owner.osi.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n4, n5);
        graphics.setColor(this.bgColor);
        graphics.fillRect(n3, n2, n4 - 2 * n3, n5 - 2 * n2);
        if (this.empty != null) {
            for (n = 0; n < this.lastpartnum + 1; ++n) {
                if (this.empty[n]) continue;
                graphics.setColor(this.colors[n]);
                double d = this.rad[n];
                int n6 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval(n3 + (int)((double)this.ppu * (this.xPos[n] - d)), n5 - n2 - (int)((double)this.ppu * (this.yPos[n] + d)), n6, n6);
                if (this.xPos[n] + d > this.rwpos) {
                    graphics.fillOval(n3 + (int)((double)this.ppu * (this.xPos[n] - d - this.rwpos)), n5 - n2 - (int)((double)this.ppu * (this.yPos[n] + d)), n6, n6);
                }
                if (this.yPos[n] + d > this.twpos) {
                    graphics.fillOval(n3 + (int)((double)this.ppu * (this.xPos[n] - d)), n5 - n2 - (int)((double)this.ppu * (this.yPos[n] + d - this.twpos)), n6, n6);
                }
                if (this.yPos[n] - d < this.bwpos) {
                    graphics.fillOval(n3 + (int)((double)this.ppu * (this.xPos[n] - d)), n5 - n2 - (int)((double)this.ppu * (this.yPos[n] + d + this.twpos)), n6, n6);
                }
                if (!(this.xPos[n] - d < this.lwpos)) continue;
                graphics.fillOval(n3 + (int)((double)this.ppu * (this.xPos[n] - d + this.rwpos)), n5 - n2 - (int)((double)this.ppu * (this.yPos[n] + d)), n6, n6);
            }
        }
        if (this.therms[0]) {
            graphics.setColor(Color.red);
            for (n = this.bwidth + 1; n < n4 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n, this.bwidth, n, this.bwidth + 5);
            }
            graphics.setColor(Color.blue);
            for (n = this.bwidth + 3; n < n4 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n, this.bwidth, n, this.bwidth + 5);
            }
        }
        if (this.therms[1]) {
            graphics.setColor(Color.red);
            for (n = this.bwidth + 1; n < n5 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n4 - this.bwidth - 5, n, n4 - this.bwidth, n);
            }
            graphics.setColor(Color.blue);
            for (n = this.bwidth + 3; n < n5 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n4 - this.bwidth - 5, n, n4 - this.bwidth, n);
            }
        }
        if (this.therms[2]) {
            graphics.setColor(Color.red);
            for (n = this.bwidth + 1; n < n4 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n, n5 - this.bwidth - 5, n, n5 - this.bwidth);
            }
            graphics.setColor(Color.blue);
            for (n = this.bwidth + 3; n < n4 - this.bwidth - 1; n += 6) {
                graphics.drawLine(n, n5 - this.bwidth - 5, n, n5 - this.bwidth);
            }
        }
        if (this.therms[3]) {
            graphics.setColor(Color.red);
            for (n = this.bwidth + 1; n < n5 - this.bwidth - 1; n += 6) {
                graphics.drawLine(this.bwidth, n, this.bwidth + 5, n);
            }
            graphics.setColor(Color.blue);
            for (n = this.bwidth + 3; n < n5 - this.bwidth - 1; n += 6) {
                graphics.drawLine(this.bwidth, n, this.bwidth + 5, n);
            }
        }
        if (this.showMessage) {
            this.paintMessage(graphics);
        }
        graphics.dispose();
    }

    public void setPpu(int n) {
        if (this.ppu > 0) {
            this.ppu = n;
            this.pause();
        } else {
            System.out.println(String.valueOf("Error in setPpu:").concat(String.valueOf(n)));
        }
    }

    public synchronized void createParticles(int n) {
        if (this.xVel == null || this.owner.osi == null) {
            this.setBounds();
        }
        if (this.xPos == null) {
            this.initializeArrays();
        }
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        if (n < 0) {
            System.out.println(String.valueOf(String.valueOf("Error: createParticles(").concat(String.valueOf(n))).concat(String.valueOf(")")));
            return;
        }
        if (n + this.lastpartnum >= this.maxp) {
            n = this.maxp - this.lastpartnum - 1;
        }
        for (int i = 0; i < n; ++i) {
            this.addParticle(0.0, 0.0, (1.0 - (double)2 * Math.random()) * (double)10, (1.0 - (double)2 * Math.random()) * (double)10, this.dsize);
        }
        if (this.autoRefresh) {
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
        }
        if (bl) {
            this.forward();
        }
    }

    public void setBoltzmann(double d) {
        this.kb = Math.abs(d);
    }

    public synchronized void setPeriodicH(boolean bl) {
        this.periodich = bl;
        if (!bl) {
            this.neighbor[7] = null;
            this.neighbor[3] = null;
            if (!this.periodicv) {
                this.neighbor[0] = null;
                this.neighbor[2] = null;
                this.neighbor[4] = null;
                this.neighbor[6] = null;
            }
        }
    }

    public synchronized void setPeriodicV(boolean bl) {
        this.periodicv = bl;
        if (!bl) {
            this.neighbor[1] = null;
            this.neighbor[5] = null;
            if (!this.periodich) {
                this.neighbor[0] = null;
                this.neighbor[2] = null;
                this.neighbor[4] = null;
                this.neighbor[6] = null;
            }
        }
    }

    public void setBorderWidth(int n) {
        if (n < 0) {
            return;
        }
        this.bwidth = n;
    }

    public void setMaxParticles(int n) {
        this.pause();
        this.maxp = n > 0 ? n : 50;
        this.initializeArrays();
    }

    public void setDefaultMass(double d) {
        if (d > 0.0) {
            this.dmass = d;
        }
    }

    public void setDefaultSize(double d) {
        this.dsize = d;
    }

    public void setDefaultColor(int n, int n2, int n3) {
        this.dcolor = new Color(n, n2, n3);
    }

    public void setDefaultTemp(double d) {
        this.dtemp = d;
    }

    void setRWPos(double d) {
        this.rwpos = d;
    }

    void setLWPos(double d) {
        this.lwpos = d;
    }

    void setTWPos(double d) {
        this.twpos = d;
    }

    void setBWPos(double d) {
        this.bwpos = d;
    }

    public void setWallTemp(int n, double d) {
        if (n >= 0 && n < 4 && d > 0.0) {
            this.wallTemps[n] = Math.abs(d);
            this.therms[n] = true;
        } else {
            System.out.println("Error in setWallTemp");
        }
    }

    public void removeWallTemp(int n) {
        if (n >= 0 && n < 4) {
            this.therms[n] = false;
        }
    }

    public double getRWPos() {
        return this.rwpos;
    }

    public double getLWPos() {
        return this.lwpos;
    }

    public double getTWPos() {
        return this.twpos;
    }

    public double getBWPos() {
        return this.bwpos;
    }

    public int setHistogram(int n, double d, double d2) {
        if (this.histogram != null) {
            this.applet.removeDataSource(this.histogram.hashCode());
            this.ensembleDataSources.removeElement(this.histogram);
            this.histogram = null;
        }
        if (n <= 0) {
            this.histogram = null;
            return 0;
        }
        this.histogram = new Histogram(n, d, d2);
        this.ensembleDataSources.addElement(this.histogram);
        return this.histogram.hashCode();
    }

    void removeDataSources() {
        Enumeration enumeration = this.ensembleDataSources.elements();
        while (enumeration.hasMoreElements()) {
            SDataSource sDataSource = (SDataSource)enumeration.nextElement();
            this.applet.removeDataSource(sDataSource.hashCode());
        }
        this.ensembleDataSources.removeAllElements();
        this.histogram = null;
    }

    public void setDefault() {
        this.pause();
        this.owner.osi = null;
        this.time = 0.0;
        this.pvolume = 0.0;
        this.setBounds();
        this.initializeArrays();
        this.removeDataSources();
        this.paintOSI();
        if (this.autoRefresh) {
            this.owner.repaint();
        }
    }

    public void pause() {
        this.applet.clock.stopClock();
    }

    public void forward() {
        if (!this.applet.clock.isRunning()) {
            this.applet.clock.startClock();
        }
    }

    public synchronized int addParticleDataSource(int n) {
        DataSource dataSource = new DataSource(n);
        this.ensembleDataSources.addElement(dataSource);
        return dataSource.hashCode();
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.time;
        this.ds[0][2] = (this.rwpos - this.lwpos) * (this.twpos - this.bwpos);
        this.ds[0][3] = this.calcTemp();
        this.ds[0][4] = this.getNumParticles();
        this.ds[0][1] = this.ds[0][4] * this.ds[0][3] / this.ds[0][2];
        this.ds[0][5] = this.qt;
        this.ds[0][6] = this.qr;
        this.ds[0][7] = this.qb;
        this.ds[0][8] = this.ql;
        this.ds[0][9] = this.pt;
        this.ds[0][10] = this.pr;
        this.ds[0][11] = this.pb;
        this.ds[0][12] = this.pl;
        this.ds[0][13] = this.dv;
        this.ds[0][14] = this.applet.clock.getDt();
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.applet;
    }

    public double getVol() {
        return (this.rwpos - this.lwpos) * (this.twpos - this.bwpos);
    }

    public double getTemp() {
        return this.calcTemp();
    }

    public int getNumParticles() {
        int n = 0;
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            ++n;
        }
        return n;
    }

    public void setMessage(String string) {
        this.showMessage = true;
        this.message = string;
    }

    void paintMessage(Graphics graphics) {
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n2 = Math.max(110, 10 + fontMetrics.stringWidth(this.message));
        graphics.setColor(Color.yellow);
        graphics.fillRect(this.owner.currentw - n2 - 3, this.owner.currenth - n - 18, n2, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.message, this.owner.currentw - n2, this.owner.currenth - n - 6);
    }

    void paintCoords(Graphics graphics) {
        this.paintCoords(graphics, this.mouseX, this.mouseY);
    }

    void paintCoords(int n, int n2) {
        Graphics graphics = this.owner.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        String string = String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.mouseFormat.form(this.xFromPix(n))))).concat(String.valueOf(" , "))).concat(String.valueOf(this.mouseFormat.form(this.yFromPix(n2))));
        Rectangle rectangle = this.owner.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(0, rectangle.height - 20, this.boxWidth - 1, 20);
    }

    double xFromPix(int n) {
        return (double)(n - this.owner.currentw / 2) / (double)this.ppu;
    }

    double yFromPix(int n) {
        return (double)(n - this.owner.currenth / 2) / (double)this.ppu;
    }

    public boolean isEnableMouse() {
        return this.enableMouse;
    }

    public void setEnableMouse(boolean bl) {
        if (this.enableMouse == bl) {
            return;
        }
        this.enableMouse = bl;
        if (this.enableMouse) {
            this.mouseMotionAdapter = new Ensemble_mouseMotionAdapter(this);
            this.owner.addMouseMotionListener(this.mouseMotionAdapter);
            this.mouseAdapter = new Ensemble_mouseAdapter(this);
            this.owner.addMouseListener(this.mouseAdapter);
        } else {
            this.owner.removeMouseMotionListener(this.mouseMotionAdapter);
            this.owner.removeMouseListener(this.mouseAdapter);
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 0) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.mouseDown = true;
            this.paintCoords(this.mouseX, this.mouseY);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.paintCoords(this.mouseX, this.mouseY);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        Rectangle rectangle = this.owner.getBounds();
        this.owner.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
    }

    public void this_mouseEntered(MouseEvent mouseEvent) {
        this.owner.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void this_mouseExited(MouseEvent mouseEvent) {
        this.owner.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void this_mouseMoved(MouseEvent mouseEvent) {
    }

    public class DataSource
    implements SDataSource {
        String[] varStrings = new String[]{"t", "x", "y", "vx", "vy", "m"};
        double[][] ds = new double[1][6];
        int index = 0;

        DataSource(int n) {
            this.index = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            this.ds[0][0] = Ensemble.this.time;
            if (this.index > Ensemble.this.xPos.length - 1) {
                System.out.println("ERROR: DataSource index is large than than number of particles.");
                this.ds[0][1] = 0.0;
                this.ds[0][2] = 0.0;
                this.ds[0][3] = 0.0;
                this.ds[0][4] = 0.0;
                this.ds[0][5] = 0.0;
                return this.ds;
            }
            if (Ensemble.this.empty[this.index]) {
                this.ds[0][1] = 0.0;
                this.ds[0][2] = 0.0;
                this.ds[0][3] = 0.0;
                this.ds[0][4] = 0.0;
                this.ds[0][5] = 0.0;
            } else {
                this.ds[0][1] = Ensemble.this.xPos[this.index] - Ensemble.this.xOrigin;
                this.ds[0][2] = Ensemble.this.yPos[this.index] - Ensemble.this.yOrigin;
                this.ds[0][3] = Ensemble.this.xVel[this.index];
                this.ds[0][4] = Ensemble.this.yVel[this.index];
                this.ds[0][5] = Ensemble.this.mass[this.index];
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return Ensemble.this.applet;
        }
    }

    public class Histogram
    implements SDataSource {
        String[] varStrings = new String[]{"v", "n"};
        double[][] ds = new double[1][2];
        int nbins = 20;
        double vmin = 0.0;
        double vmax = 10.0;

        Histogram(int n, double d, double d2) {
            this.nbins = n;
            this.vmin = d;
            this.vmax = d2;
            this.ds = new double[this.nbins][2];
            double d3 = (this.vmax - this.vmin) / (double)this.nbins;
            double d4 = this.vmin + d3 / (double)2;
            for (int i = 0; i < this.nbins; ++i) {
                this.ds[i][0] = d4;
                d4 += d3;
            }
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            int n;
            double d = 0.0;
            double d2 = (this.vmax - this.vmin) / (double)this.nbins;
            int n2 = 0;
            for (n = 0; n < this.nbins; ++n) {
                this.ds[n][1] = 0.0;
            }
            for (n = 0; n < Ensemble.this.lastpartnum + 1; ++n) {
                if (Ensemble.this.empty[n] || (n2 = (int)Math.floor(((d = Math.sqrt(Ensemble.this.xVel[n] * Ensemble.this.xVel[n] + Ensemble.this.yVel[n] * Ensemble.this.yVel[n])) - this.vmin) / d2)) < 0 || n2 >= this.nbins) continue;
                double[] dArray = this.ds[n2];
                dArray[1] = dArray[1] + 1.0;
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return Ensemble.this.applet;
        }
    }
}

