/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import molecular.Ensemble;

public class EnsemblePanel
extends Panel {
    Color txtcolor = Color.red;
    boolean showTitle = false;
    int txtxoff = 0;
    int txtyoff = 0;
    String title = null;
    int currentw = 0;
    int currenth = 0;
    double cwpos = 0.0;
    double lcwpos = 0.0;
    double rcwpos = 0.0;
    int bwidth = 0;
    int ppu = 10;
    Image osi = null;
    SApplet owner = null;
    Ensemble ensemble1 = null;

    public EnsemblePanel(SApplet sApplet) {
        this.owner = sApplet;
        this.ensemble1 = new Ensemble(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void makeImage() {
        this.osi = this.createImage(this.currentw, this.currenth);
        while (!this.prepareImage(this.osi, this)) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            if (this.getSize().width <= 2) return;
            boolean bl = this.owner.clock.isRunning();
            this.owner.clock.stopClock();
            this.ensemble1.setBounds();
            this.ensemble1.paintOSI();
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
            if (bl) {
                this.owner.clock.startClock();
            }
        } else {
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
        }
        if (this.showTitle) {
            this.paintCaption(graphics);
        }
        if (!this.ensemble1.mouseDown) return;
        this.ensemble1.paintCoords(graphics);
    }

    public void addCaption(String string) {
        this.showTitle = true;
        this.title = string;
    }

    void paintCaption(Graphics graphics) {
        Font font = graphics.getFont();
        Font font2 = new Font("Arial", 1, 14);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = fontMetrics.stringWidth(this.title);
        graphics.setColor(this.txtcolor);
        graphics.drawString(this.title, this.txtxoff + (this.currentw - n) / 2, this.txtyoff + (int)(0.1 * (double)this.currenth));
        graphics.setFont(font);
    }

    public Ensemble getEnsemble() {
        return this.ensemble1;
    }

    public EnsemblePanel() {
    }
}

