/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.awt.Color;
import java.awt.Graphics;
import molecular.EnsemblePanel;
import molecular.MLEnsemble;
import molecular.MREnsemble;

public class MEnsemblePanel
extends EnsemblePanel
implements SStepable {
    int nCollidingW = 0;
    int nCollidingE = 1;
    double time = 0.0;
    double mint = 10000.0;
    double temptime = 10000.0;
    double weight = 100.0;
    double wVel = 0.0;
    MLEnsemble ensemble1 = null;
    MREnsemble ensemble2 = null;
    double wwidth = 1.3;
    Parser pparser = null;

    public MEnsemblePanel(SApplet sApplet) {
        super(sApplet);
        this.ensemble1 = new MLEnsemble(this);
        this.ensemble2 = new MREnsemble(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void step(double d, double d2) {
        double d3 = d;
        this.ensemble1.clearPressureCounters();
        this.ensemble2.clearPressureCounters();
        do {
            if (d3 < this.mint) {
                this.mint -= d3;
                d3 -= this.advanceDT(d3);
                continue;
            }
            d3 -= this.advanceDT(this.mint);
            this.updateTimes(this.temptime);
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles();
                    break;
                }
                case 1: {
                    this.collideTW();
                    break;
                }
                case 2: {
                    this.collideRW();
                    break;
                }
                case 3: {
                    this.collideBW();
                    break;
                }
                case 4: {
                    this.collideLW();
                }
            }
            this.findMinColTime();
        } while (d3 > 0.0);
        this.paintOSI();
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.time = d2 + d;
        this.ensemble1.adjustPressureCounters(d);
        this.ensemble2.adjustPressureCounters(d);
        if (this.ensemble1.histogram != null) {
            this.owner.clearData(this.ensemble1.histogram.hashCode());
        }
        if (this.ensemble2.histogram != null) {
            this.owner.clearData(this.ensemble2.histogram.hashCode());
        }
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
    }

    public void collideParticles() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideParticles(this.ensemble1.nColliding1, this.ensemble1.nColliding2);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideParticles(this.ensemble2.nColliding1, this.ensemble2.nColliding2);
        }
    }

    public void collideTW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideTW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideTW(this.ensemble2.nColliding1);
        }
    }

    public void collideRW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideRW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideRW(this.ensemble2.nColliding1);
        }
    }

    public void collideBW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideBW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideBW(this.ensemble2.nColliding1);
        }
    }

    public void collideLW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideLW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideLW(this.ensemble2.nColliding1);
        }
    }

    public double advanceDT(double d) {
        this.ensemble1.advanceDT(d);
        this.ensemble2.advanceDT(d);
        return d;
    }

    public void updateTimes(double d) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            if (this.ensemble1.empty[n2]) continue;
            int n3 = n2;
            this.ensemble1.rwColTimes[n3] = this.ensemble1.rwColTimes[n3] - d;
            int n4 = n2;
            this.ensemble1.lwColTimes[n4] = this.ensemble1.lwColTimes[n4] - d;
            int n5 = n2;
            this.ensemble1.twColTimes[n5] = this.ensemble1.twColTimes[n5] - d;
            int n6 = n2;
            this.ensemble1.bwColTimes[n6] = this.ensemble1.bwColTimes[n6] - d;
        }
        for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble1.empty[n2] || this.ensemble1.empty[n]) continue;
                double[] dArray = this.ensemble1.colTimes[n2];
                int n7 = n;
                dArray[n7] = dArray[n7] - d;
            }
        }
        for (n2 = 0; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            if (this.ensemble2.empty[n2]) continue;
            int n8 = n2;
            this.ensemble2.rwColTimes[n8] = this.ensemble2.rwColTimes[n8] - d;
            int n9 = n2;
            this.ensemble2.lwColTimes[n9] = this.ensemble2.lwColTimes[n9] - d;
            int n10 = n2;
            this.ensemble2.twColTimes[n10] = this.ensemble2.twColTimes[n10] - d;
            int n11 = n2;
            this.ensemble2.bwColTimes[n11] = this.ensemble2.bwColTimes[n11] - d;
        }
        for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble2.empty[n2] || this.ensemble2.empty[n]) continue;
                double[] dArray = this.ensemble2.colTimes[n2];
                int n12 = n;
                dArray[n12] = dArray[n12] - d;
            }
        }
    }

    public double findMinColTime() {
        this.ensemble1.findMinColTime();
        this.ensemble2.findMinColTime();
        double d = this.ensemble1.mint;
        double d2 = this.ensemble2.mint;
        if (d < d2) {
            this.nCollidingE = 1;
            this.nCollidingW = this.ensemble1.nCollidingW;
            this.temptime = this.mint = d;
            return d;
        }
        this.nCollidingE = 2;
        this.nCollidingW = this.ensemble2.nCollidingW;
        this.temptime = this.mint = d2;
        return d2;
    }

    public void paintOSI() {
        int n;
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.ensemble1.bgColor);
        graphics.fillRect(0, 0, this.currentw, this.currenth);
        this.ensemble1.paintOSI();
        this.ensemble2.paintOSI();
        graphics.setColor(Color.black);
        graphics.drawLine((int)((double)this.ppu * this.cwpos), this.currenth, (int)((double)this.ppu * this.cwpos), 0);
        int n2 = (int)((this.cwpos - this.wwidth) * (double)this.ppu);
        int n3 = (int)((this.cwpos + this.wwidth) * (double)this.ppu);
        graphics.setColor(Color.white);
        for (n = this.bwidth + 1; n < this.currenth - this.bwidth - 1; n += 6) {
            graphics.drawLine(n2, n, n3, n);
        }
        graphics.setColor(Color.black);
        for (n = this.bwidth + 3; n < this.currenth - this.bwidth - 1; n += 6) {
            graphics.drawLine(n2, n, n3, n);
        }
        graphics.dispose();
    }

    public void setDefault() {
        this.wVel = 0.0;
        this.ensemble1.setDefault();
        this.ensemble2.setDefault();
    }

    public void setBounds() {
        this.currentw = this.getSize().width;
        this.currenth = this.getSize().height;
        this.ensemble1.setRWPos(0.5 * (double)this.currentw / (double)this.ppu);
        this.ensemble1.setLWPos(0.0);
        this.ensemble1.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble1.setBWPos(0.0);
        this.ensemble1.xOrigin = (this.ensemble1.rwpos + this.ensemble1.lwpos) / (double)2;
        this.ensemble1.yOrigin = this.ensemble1.twpos / (double)2;
        this.cwpos = this.ensemble1.rwpos;
        this.ensemble1.setPeriodicV(false);
        if (this.ensemble1.periodicv) {
            this.ensemble1.setNeighbor(1, this.ensemble1, 0.0, this.ensemble1.twpos);
            this.ensemble1.setNeighbor(5, this.ensemble1, 0.0, -this.ensemble1.twpos);
        }
        this.ensemble1.setPeriodicH(false);
        this.ensemble2.setLWPos(this.cwpos);
        this.ensemble2.setRWPos((double)this.currentw / (double)this.ppu);
        this.ensemble2.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble2.setBWPos(0.0);
        this.ensemble2.xOrigin = (this.ensemble2.rwpos + this.ensemble2.lwpos) / (double)2;
        this.ensemble2.yOrigin = this.ensemble2.twpos / (double)2;
        this.ensemble2.setPeriodicV(false);
        if (this.ensemble2.periodicv) {
            this.ensemble2.setNeighbor(1, this.ensemble2, 0.0, this.ensemble2.twpos);
            this.ensemble2.setNeighbor(5, this.ensemble2, 0.0, -this.ensemble2.twpos);
        }
        this.ensemble2.setPeriodicH(false);
        this.makeImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            if (this.getSize().width <= 2) return;
            boolean bl = this.owner.clock.isRunning();
            this.owner.clock.stopClock();
            this.setBounds();
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
            if (bl) {
                this.owner.clock.startClock();
            }
        } else {
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
        }
        if (this.showTitle) {
            this.paintCaption(graphics);
        }
        if (this.ensemble1.mouseDown) {
            this.ensemble1.paintCoords(graphics);
        }
        if (!this.ensemble2.mouseDown) return;
        this.ensemble2.paintCoords(graphics);
    }

    public boolean setProbabilityFunction(String string) {
        boolean bl = true;
        String string2 = string;
        string2.toLowerCase().trim();
        this.pparser = new Parser(1);
        this.pparser.define(string2);
        this.pparser.defineVariable(1, "m");
        this.pparser.parse();
        if (this.pparser.getErrorCode() != 0) {
            bl = false;
            System.out.println(String.valueOf("Failed to parse P(m)): ").concat(String.valueOf(string2)));
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error in MathFunction: ").concat(String.valueOf(this.pparser.getErrorString()))).concat(String.valueOf(" at function 1, position "))).concat(String.valueOf(this.pparser.getErrorPosition())));
        }
        return bl;
    }

    public MLEnsemble getEnsemble1() {
        return this.ensemble1;
    }

    public MREnsemble getEnsemble2() {
        return this.ensemble2;
    }

    public void setPistonWidth(double d) {
        if (d > 0.0) {
            this.wwidth = d;
        }
    }

    public void setPistonMass(double d) {
        if (d > 0.0) {
            this.weight = d;
        }
    }

    public MEnsemblePanel() {
    }

    public void recalculateColTimes() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            if (this.ensemble1.empty[n2]) continue;
            n = n2;
            this.ensemble1.rwColTimes[n2] = this.ensemble1.calcColTimeRW(n2);
            this.ensemble1.lwColTimes[n2] = this.ensemble1.calcColTimeLW(n2);
            this.ensemble1.twColTimes[n2] = this.ensemble1.calcColTimeTW(n2);
            this.ensemble1.bwColTimes[n2] = this.ensemble1.calcColTimeBW(n2);
        }
        for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble1.empty[n] || this.ensemble1.empty[n2]) continue;
                this.ensemble1.colTimes[n2][n] = this.ensemble1.calcColTime(n2, n);
            }
        }
        for (n2 = 0; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            if (this.ensemble2.empty[n2]) continue;
            n = n2;
            this.ensemble2.rwColTimes[n2] = this.ensemble2.calcColTimeRW(n2);
            this.ensemble2.lwColTimes[n2] = this.ensemble2.calcColTimeLW(n2);
            this.ensemble2.twColTimes[n2] = this.ensemble2.calcColTimeTW(n2);
            this.ensemble2.bwColTimes[n2] = this.ensemble2.calcColTimeBW(n2);
        }
        for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble2.empty[n] || this.ensemble2.empty[n2]) continue;
                this.ensemble2.colTimes[n2][n] = this.ensemble2.calcColTime(n2, n);
            }
        }
        this.findMinColTime();
    }
}

