/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Graphics;
import molecular.Ensemble;
import molecular.MFEnsemblePanel;

public class MFEnsemble
extends Ensemble {
    MFEnsemble[] neighbor = new MFEnsemble[8];
    MFEnsemblePanel owner = null;
    int midHeight = 10;
    double top;
    double bottom;

    public MFEnsemble() {
    }

    public MFEnsemble(MFEnsemblePanel mFEnsemblePanel) {
        super(mFEnsemblePanel);
        this.owner = mFEnsemblePanel;
        this.applet = this.owner.owner;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBounds() {
        this.owner.setBounds();
    }

    public double calcColTimeLW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: calcColTimeLW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.xVel[n] < 0.0 && this.xPos[n] > this.lwpos) {
            return Math.max(0.0, (this.lwpos - this.xPos[n]) / this.xVel[n]);
        }
        return 10000.0;
    }

    public double calcColTimeRW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: calcColTimeRW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.xVel[n] > 0.0 && this.xPos[n] < this.rwpos) {
            return Math.max(0.0, (this.rwpos - this.xPos[n]) / this.xVel[n]);
        }
        return 10000.0;
    }

    public double calcColTime(int n, int n2) {
        if (!this.owner.partInt) {
            return 10000.0;
        }
        double d = 10000.0;
        if (!this.empty[n] && !this.empty[n2]) {
            int n3 = Math.max(n, n2);
            int n4 = Math.min(n, n2);
            double d2 = this.xVel[n3] - this.xVel[n4];
            double d3 = this.yVel[n3] - this.yVel[n4];
            double d4 = this.yPos[n3] - this.yPos[n4];
            double d5 = this.xPos[n3] - this.xPos[n4];
            if (Math.sqrt(d4 * d4 + d5 * d5) < this.rad[n3] + this.rad[n4] - 0.001) {
                return 10000.0;
            }
            double d6 = d2 * d5 + d3 * d4;
            if (d6 >= 0.0) {
                d = 10000.0;
            } else {
                double d7 = d2 * d2 + d3 * d3;
                double d8 = d5 * d5 + d4 * d4;
                double d9 = (this.rad[n3] + this.rad[n4]) * (this.rad[n3] + this.rad[n4]);
                double d10 = d6 * d6 - d7 * (d8 - d9);
                if (d10 < 0.0) {
                    d = 10000.0;
                } else {
                    if (d8 < (this.rad[n3] + this.rad[n4]) * (this.rad[n3] + this.rad[n4])) {
                        return 10000.0;
                    }
                    double d11 = (-d6 - Math.sqrt(d10)) / d7;
                    d = Math.max(0.0, d11);
                    return d;
                }
            }
        }
        return d;
    }

    public double calcImageCollisionTime(int n, int n2) {
        double d = 10000.0;
        if (this.empty[n] || this.empty[n2]) {
            return 10000.0;
        }
        MFEnsemble mFEnsemble = null;
        for (int i = 0; i < 8; ++i) {
            mFEnsemble = this.neighbor[i];
            if (mFEnsemble == null || mFEnsemble != this) continue;
            d = Math.min(d, this.calcColTimeIm(n, n2, i, this.xOff[i], this.yOff[i]));
        }
        return Math.max(0.0, d);
    }

    public double calcImageColTimes(int n, int n2) {
        if (this.empty[n]) {
            return 10000.0;
        }
        MFEnsemble mFEnsemble = this.neighbor[n2];
        double d = 10000.0;
        if (mFEnsemble != null) {
            for (int i = 0; i < mFEnsemble.lastpartnum + 1; ++i) {
                if (mFEnsemble.empty[i]) continue;
                d = Math.min(d, this.calcColTimeIm(n, i, n2, 0.0, 0.0));
            }
        }
        return d;
    }

    public double calcColTimeIm(int n, int n2, int n3, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        MFEnsemble mFEnsemble = this.neighbor[n3];
        double d8 = mFEnsemble.xPos[n2] + d;
        double d9 = mFEnsemble.yPos[n2] + d2;
        double d10 = mFEnsemble.xVel[n2];
        double d11 = mFEnsemble.yVel[n2];
        double d12 = mFEnsemble.rad[n2];
        double d13 = this.xVel[n] - d10;
        double d14 = this.xPos[n] - d8;
        double d15 = this.yVel[n] - d11;
        double d16 = this.yPos[n] - d9;
        double d17 = d13 * d14 + d15 * d16;
        double d18 = d17 >= 0.0 ? 10000.0 : ((d7 = d17 * d17 - (d6 = d13 * d13 + d15 * d15) * ((d5 = d14 * d14 + d16 * d16) - (d4 = (this.rad[n] + d12) * (this.rad[n] + d12)))) < 0.0 ? 10000.0 : (d3 = (-d17 - Math.sqrt(d7)) / d6));
        return Math.max(0.0, d18);
    }

    public void collideParticles(int n, int n2) {
        int n3;
        if (!this.owner.partInt) {
            return;
        }
        int n4 = Math.max(n, n2);
        int n5 = Math.min(n, n2);
        if (this.empty[n4] || this.empty[n5]) {
            return;
        }
        if (this.mass[n4] != this.mass[n5]) {
            this.collideDiffMassParticles(n4, n5);
        } else {
            double d = this.rad[n] + this.rad[n2];
            double d2 = this.xVel[n4] - this.xVel[n5];
            double d3 = this.yVel[n4] - this.yVel[n5];
            double d4 = this.xPos[n5] - this.xPos[n4];
            double d5 = this.yPos[n5] - this.yPos[n4];
            if (d4 > d) {
                d4 -= this.rwpos - this.lwpos;
            }
            if (d5 > d) {
                d5 -= this.twpos;
            }
            if (d4 < -d) {
                d4 += this.rwpos - this.lwpos;
            }
            if (d5 < -d) {
                d5 += this.twpos;
            }
            double d6 = d4 * d4 + d5 * d5;
            double d7 = d2 * d4 + d3 * d5;
            this.xVel[n4] = this.xVel[n4] - d7 * d4 / d6;
            this.yVel[n4] = this.yVel[n4] - d7 * d5 / d6;
            this.xVel[n5] = this.xVel[n5] + d7 * d4 / d6;
            this.yVel[n5] = this.yVel[n5] + d7 * d5 / d6;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.colTimes[n4][n3] = this.calcColTime(n4, n3);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            this.colTimes[n5][n3] = this.calcColTime(n5, n3);
        }
        for (n3 = n5 + 1; n3 < this.lastpartnum + 1; ++n3) {
            this.colTimes[n3][n5] = this.calcColTime(n3, n5);
        }
        for (n3 = n4 + 1; n3 < this.lastpartnum + 1; ++n3) {
            this.colTimes[n3][n4] = this.calcColTime(n3, n4);
        }
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        this.bwColTimes[n2] = this.calcColTimeBW(n2);
        this.lwColTimes[n2] = this.calcColTimeLW(n2);
        this.rwColTimes[n2] = this.calcColTimeRW(n2);
        this.twColTimes[n2] = this.calcColTimeTW(n2);
    }

    public void collideDiffMassParticles(int n, int n2) {
        if (!this.owner.partInt) {
            return;
        }
        double d = this.rad[n] + this.rad[n2];
        double d2 = this.mass[n];
        double d3 = this.mass[n2];
        double d4 = this.xPos[n];
        double d5 = this.xPos[n2];
        double d6 = this.xPos[n] - this.xPos[n2];
        double d7 = this.yPos[n] - this.yPos[n2];
        double d8 = this.xVel[n];
        double d9 = this.xVel[n2];
        double d10 = this.yVel[n];
        double d11 = this.yVel[n2];
        double d12 = (d2 * d8 + d3 * d9) / (d2 + d3);
        double d13 = (d2 * d10 + d3 * d11) / (d2 + d3);
        d8 -= d12;
        d10 -= d13;
        d9 -= d12;
        d11 -= d13;
        if (d6 > d + 0.1) {
            d6 -= this.rwpos - this.lwpos;
        }
        if (d7 > d + 0.1) {
            d7 -= this.twpos;
        }
        if (d6 < -d - 0.1) {
            d6 += this.rwpos - this.lwpos;
        }
        if (d7 < -d - 0.1) {
            d7 += this.twpos;
        }
        double d14 = d6 / d;
        double d15 = d7 / d;
        double d16 = -d14;
        double d17 = -d15;
        double d18 = Math.abs(d14 * d8 + d15 * d10);
        double d19 = Math.abs(d16 * d9 + d17 * d11);
        int n3 = n;
        this.xVel[n3] = this.xVel[n3] + (double)2 * d18 * d14;
        int n4 = n;
        this.yVel[n4] = this.yVel[n4] + (double)2 * d18 * d15;
        int n5 = n2;
        this.xVel[n5] = this.xVel[n5] + (double)2 * d19 * d16;
        int n6 = n2;
        this.yVel[n6] = this.yVel[n6] + (double)2 * d19 * d17;
    }

    public void collideTW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: colliding empty particle:").concat(String.valueOf(n)));
            return;
        }
        this.pt += Math.abs(this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        if (this.neighbor[1] != null) {
            this.yPos[n] = this.bwpos;
        } else if (this.therms[0]) {
            this.thermalize(n, 0);
        } else {
            this.yVel[n] = -this.yVel[n];
        }
        this.pt += Math.abs(-this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        if (this.owner.partInt) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    public double calcColTimeBW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: calcColTimeBW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.yVel[n] < 0.0 && this.neighbor[5] == null) {
            if (this.yPos[n] - this.rad[n] > this.bwpos) {
                return Math.max(0.0, (this.bwpos + this.rad[n] - this.yPos[n]) / this.yVel[n]);
            }
            if (this.yPos[n] > this.bwpos) {
                return Math.max(0.0, (this.bwpos - this.yPos[n]) / this.yVel[n]);
            }
        }
        return 10000.0;
    }

    public double calcColTimeTW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: calcColTimeTW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.yVel[n] > 0.0 && this.neighbor[1] == null) {
            if (this.yPos[n] + this.rad[n] < this.twpos) {
                return Math.max(0.0, (this.twpos - this.rad[n] - this.yPos[n]) / this.yVel[n]);
            }
            if (this.yPos[n] < this.twpos) {
                return Math.max(0.0, (this.twpos - this.yPos[n]) / this.yVel[n]);
            }
        }
        return 10000.0;
    }

    public void collideBW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: colliding empty particle:").concat(String.valueOf(n)));
            return;
        }
        this.pb += Math.abs(this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        if (this.neighbor[5] != null) {
            this.yPos[n] = this.twpos;
        } else if (this.therms[2]) {
            this.thermalize(n, 2);
        } else {
            this.yVel[n] = -this.yVel[n];
        }
        this.pb += Math.abs(-this.yVel[n] * this.mass[n] / (this.rwpos - this.lwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        if (this.owner.partInt) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    public void collideLW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: colliding empty particle:").concat(String.valueOf(n)));
            return;
        }
        double d = this.yPos[n] - this.owner.ensemble1.yOrigin;
        double d2 = this.xVel[n];
        double d3 = this.yVel[n];
        double d4 = this.rad[n];
        double d5 = this.owner.ensemble1.xOrigin;
        double d6 = this.owner.ensemble1.rwpos - d5 + 1.0E-4;
        this.owner.ensemble1.setDefaultColor(this.colors[n].getRed(), this.colors[n].getGreen(), this.colors[n].getBlue());
        this.owner.ensemble1.setDefaultMass(this.mass[n]);
        this.owner.ensemble1.addParticle(d6, d, d2, d3, d4);
        this.removeParticle(n);
    }

    public void collideRW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Middle: colliding empty particle:").concat(String.valueOf(n)));
            return;
        }
        double d = this.yPos[n] - this.owner.ensemble2.yOrigin;
        double d2 = this.xVel[n];
        double d3 = this.yVel[n];
        double d4 = this.rad[n];
        double d5 = this.owner.ensemble2.lwpos + 1.0E-4 - this.owner.ensemble2.xOrigin;
        this.owner.ensemble2.setDefaultColor(this.colors[n].getRed(), this.colors[n].getGreen(), this.colors[n].getBlue());
        this.owner.ensemble2.setDefaultMass(this.mass[n]);
        this.owner.ensemble2.addParticle(d5, d, d2, d3, d4);
        this.removeParticle(n);
    }

    void iflowPart() {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            this.pause();
            bl = true;
        }
        double d = this.dsize;
        int n = this.findEmptyPart();
        this.setParticle(n, this.lwpos + this.dsize + 0.001, 0.001 + d + Math.random() * (this.twpos - d - d - 0.002), Math.random() * (double)10, (1.0 - (double)2 * Math.random()) * (double)10, d);
        this.recalculateColTimes();
        if (bl) {
            this.forward();
        }
    }

    void oflowPart() {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            this.pause();
            bl = true;
        }
        this.removeParticles(1);
        this.recalculateColTimes();
        if (bl) {
            this.forward();
        }
    }

    void oflowPart(int n) {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            this.pause();
            bl = true;
        }
        this.removeParticle(n);
        this.recalculateColTimes();
        if (bl) {
            this.forward();
        }
    }

    void setParticle(int n, double d, double d2, double d3, double d4, double d5) {
        if (this.xVel == null || this.owner.osi == null) {
            this.setBounds();
        }
        if (this.xPos == null) {
            this.initializeArrays();
        }
        if (n < this.xVel.length && this.xVel != null) {
            this.lastpartnum = Math.max(n, this.lastpartnum);
            if (d5 + 0.001 > (this.rwpos + this.lwpos) / (double)2) {
                d5 = 2.0;
            }
            this.rad[n] = d5;
            if (this.periodich && (d + this.rad[n] > this.rwpos || d - this.rad[n] < this.lwpos)) {
                d = (this.rwpos + this.lwpos) / (double)2;
                this.rad[n] = Math.min(this.rad[n], this.rwpos - d - 0.01);
            }
            if (this.periodicv && (d2 + this.rad[n] > this.twpos || d2 - this.rad[n] < this.bwpos)) {
                d2 = (this.twpos + this.bwpos) / (double)2;
                this.rad[n] = Math.min(this.rad[n], this.twpos - d2 - 0.01);
            }
            this.xPos[n] = d;
            this.yPos[n] = d2;
            this.xVel[n] = d3;
            this.yVel[n] = d4;
            this.empty[n] = false;
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            this.bwColTimes[n] = this.calcColTimeBW(n);
            if (this.owner.partInt) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    this.colTimes[n][n2] = this.calcColTime(n, n2);
                }
                for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                    this.colTimes[n2][n] = this.calcColTime(n2, n);
                }
            }
            this.mass[n] = this.dmass;
            this.colors[n] = this.dcolor;
        } else {
            System.out.println(String.valueOf("Error in setParticle. Particle index out or range:").concat(String.valueOf(n)));
        }
    }

    public void findMinColTime() {
        if (this.empty == null) {
            return;
        }
        double d = this.applet.clock.getDt();
        double d2 = 10000.0;
        double d3 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d2) {
                d2 = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
                if (d2 <= 0.0) {
                    System.out.println("Middle: tWColTime <= 0");
                    this.pause();
                }
            }
            if (this.rwColTimes[0] < d2) {
                d2 = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
                if (d2 <= 0.0) {
                    System.out.println("Middle: rWColTime <= 0");
                    this.pause();
                }
            }
            if (this.bwColTimes[0] < d2) {
                d2 = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
                if (d2 <= 0.0) {
                    System.out.println("Middle: bWColTime <= 0");
                    this.pause();
                }
            }
            if (this.lwColTimes[0] < d2) {
                d2 = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
                if (d2 <= 0.0) {
                    System.out.println("Middle: LWColTime <= 0");
                    this.pause();
                }
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d2) {
                d2 = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
                if (d2 <= 0.0) {
                    System.out.println("Middle: tWColTime <= 0");
                    this.pause();
                }
            }
            if (this.rwColTimes[i] < d2) {
                d2 = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
                if (d2 <= 0.0) {
                    System.out.println("Middle: rWColTime <= 0");
                    this.pause();
                }
            }
            if (this.bwColTimes[i] < d2) {
                d2 = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
                if (d2 <= 0.0) {
                    System.out.println("Middle: bWColTime <= 0");
                    this.pause();
                }
            }
            if (this.lwColTimes[i] < d2) {
                d2 = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
                if (d2 <= 0.0) {
                    System.out.println("Middle: LWColTime <= 0");
                    this.pause();
                }
            }
            if (!this.owner.partInt) continue;
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d2)) continue;
                d2 = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
                if (!(d2 <= 0.0)) continue;
                System.out.println("Middle: PartColTime <= 0");
                this.pause();
            }
        }
        if (d2 < 0.0) {
            System.out.println("Middle: negative Collide Time");
            this.pause();
            d2 = 10000.0;
        }
        if (d2 == 0.0) {
            System.out.println("Middle: Collide Time = 0");
            this.pause();
            d2 = 10000.0;
        }
        this.temptime = this.mint = d2;
    }

    void clearColTimes(int n) {
        this.empty[n] = true;
        this.twColTimes[n] = 10000.0;
        this.rwColTimes[n] = 10000.0;
        this.bwColTimes[n] = 10000.0;
        this.lwColTimes[n] = 10000.0;
        if (this.owner.partInt) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = 10000.0;
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = 10000.0;
            }
        }
    }

    void setNeighbor(int n, MFEnsemble mFEnsemble, double d, double d2) {
        this.neighbor[n] = mFEnsemble;
        this.xOff[n] = d;
        this.yOff[n] = d2;
    }

    void initializeArrays() {
        int n;
        if (this.maxp <= 0) {
            this.maxp = 50;
        }
        if (this.owner.partInt) {
            this.colTimes = new double[this.maxp][];
            for (n = 0; n < this.maxp; ++n) {
                this.colTimes[n] = new double[n + 1];
            }
        }
        this.rwColTimes = new double[this.maxp];
        this.lwColTimes = new double[this.maxp];
        this.twColTimes = new double[this.maxp];
        this.bwColTimes = new double[this.maxp];
        this.xVel = new double[this.maxp];
        this.yVel = new double[this.maxp];
        this.xPos = new double[this.maxp];
        this.yPos = new double[this.maxp];
        this.mass = new double[this.maxp];
        this.rad = new double[this.maxp];
        this.colors = new Color[this.maxp];
        this.empty = new boolean[this.maxp];
        for (n = 0; n < this.maxp; ++n) {
            this.empty[n] = true;
        }
        this.lastpartnum = -1;
    }

    public void recalculateColTimes(int n) {
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        if (this.owner.partInt) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
        this.findMinColTime();
    }

    public void recalculateColTimes() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.lastpartnum + 1; ++n2) {
            if (this.empty[n2]) continue;
            n = n2;
            this.rwColTimes[n2] = this.calcColTimeRW(n2);
            this.lwColTimes[n2] = this.calcColTimeLW(n2);
            this.twColTimes[n2] = this.calcColTimeTW(n2);
            this.bwColTimes[n2] = this.calcColTimeBW(n2);
        }
        if (this.owner.partInt) {
            for (n2 = 1; n2 < this.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.empty[n] || this.empty[n2]) continue;
                    this.colTimes[n2][n] = this.calcColTime(n2, n);
                }
            }
        }
        this.findMinColTime();
    }

    public synchronized void paintOSI() {
        int n = (int)((this.rwpos - this.lwpos) * (double)this.ppu);
        int n2 = (int)(this.lwpos * (double)this.ppu);
        int n3 = (int)((this.twpos - this.bwpos) * (double)this.ppu);
        int n4 = (int)((this.top - this.bottom) * (double)this.ppu);
        int n5 = (int)((double)this.ppu * (this.top - this.twpos));
        if (this.owner.osi != null) {
            Graphics graphics = this.owner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(this.bgColor);
            graphics.fillRect(n2 - 1, n5, n + 2, n3);
            int n6 = 1;
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                graphics.setColor(this.colors[i]);
                double d = this.rad[i];
                n6 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n4 - (int)((double)this.ppu * (this.yPos[i] + d)), n6, n6);
            }
            if (this.therms[0]) {
                // empty if block
            }
            if (this.therms[1]) {
                // empty if block
            }
            if (this.therms[2]) {
                // empty if block
            }
            if (this.therms[3]) {
                // empty if block
            }
            graphics.dispose();
        }
    }

    public synchronized void setPeriodicV(boolean bl) {
        this.periodicv = bl;
        if (!bl) {
            this.neighbor[1] = null;
            this.neighbor[5] = null;
            if (!this.periodich) {
                this.neighbor[0] = null;
                this.neighbor[2] = null;
                this.neighbor[4] = null;
                this.neighbor[6] = null;
            }
        }
    }

    void setRWPos(double d) {
        this.rwpos = d;
    }

    void setLWPos(double d) {
        this.lwpos = d;
    }

    void setTWPos(double d) {
        this.twpos = d;
    }

    void setBWPos(double d) {
        this.bwpos = d;
    }

    public void thermalize(int n, int n2) {
        if (n < 0 || n >= this.maxp || this.mass[n] <= 0.0) {
            System.out.println("Error in thermalize: mass=0?");
            return;
        }
        double d = this.wallTemps[n2];
        double d2 = Math.sqrt(this.xVel[n] * this.xVel[n] + this.yVel[n] * this.yVel[n]);
        double d3 = Math.sqrt((double)2 * this.kb * d / this.mass[n]);
        if (n2 == 0) {
            this.yVel[n] = -d3 * Math.random();
            if (Math.random() < 0.5) {
                this.xVel[n] = Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            }
            this.xVel[n] = -Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            this.qt += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 1) {
            this.xVel[n] = -d3 * Math.random();
            this.yVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]) : -Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]);
            this.qr += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 2) {
            this.yVel[n] = d3 * Math.random();
            this.xVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]) : -Math.sqrt(d3 * d3 - this.yVel[n] * this.yVel[n]);
            this.qb += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        } else if (n2 == 3) {
            this.xVel[n] = d3 * Math.random();
            this.yVel[n] = Math.random() < 0.5 ? Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]) : -Math.sqrt(d3 * d3 - this.xVel[n] * this.xVel[n]);
            this.ql += 0.5 * this.mass[n] * (d3 * d3 - d2 * d2);
        }
    }

    private void switchVelocity(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n >= this.empty.length) {
            System.out.println(String.valueOf("switchVelocity: ").concat(String.valueOf(n)));
            return;
        }
        do {
            n2 = (int)Math.floor((double)this.lastpartnum * Math.random());
        } while (this.empty[n2 = Math.min(n2, this.lastpartnum)] && ++n3 < 2 * this.lastpartnum);
        if (this.empty[n2]) {
            System.out.println("Error: Cannot find non-empty particle. No particle switch.");
            return;
        }
        double d = this.xVel[n];
        double d2 = this.yVel[n];
        this.xVel[n] = this.xVel[n2];
        this.yVel[n] = this.yVel[n2];
        this.xVel[n2] = d;
        this.xVel[n2] = d2;
        this.bwColTimes[n2] = this.calcColTimeBW(n2);
        this.lwColTimes[n2] = this.calcColTimeLW(n2);
        this.rwColTimes[n2] = this.calcColTimeRW(n2);
        this.twColTimes[n2] = this.calcColTimeTW(n2);
        if (this.owner.partInt) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                this.colTimes[n2][n4] = this.calcColTime(n2, n4);
            }
            for (n4 = n2 + 1; n4 < this.lastpartnum + 1; ++n4) {
                this.colTimes[n4][n2] = this.calcColTime(n4, n2);
            }
        }
    }

    public void setDefault() {
        this.pause();
        this.owner.osi = null;
        this.time = 0.0;
        this.pvolume = 0.0;
        this.setBounds();
        this.initializeArrays();
        this.removeDataSources();
        this.paintOSI();
        if (this.autoRefresh) {
            this.owner.repaint();
        }
    }
}

