/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import java.awt.Color;
import java.awt.Graphics;
import molecular.MFEnsemble;
import molecular.MFEnsemblePanel;

public class MFREnsemble
extends MFEnsemble {
    double oRProb = 0.0;
    MFEnsemblePanel owner = null;

    public MFREnsemble(MFEnsemblePanel mFEnsemblePanel) {
        super(mFEnsemblePanel);
        this.owner = mFEnsemblePanel;
        this.dcolor = new Color(150, 0, 0);
    }

    public void setBounds() {
        this.owner.setBounds();
    }

    public double calcColTimeLW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Right: calcColTimeLW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.xVel[n] < 0.0 && this.xPos[n] > this.lwpos) {
            return Math.abs((this.lwpos - this.xPos[n]) / this.xVel[n]);
        }
        return 10000.0;
    }

    public double calcColTimeRW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("Right: calcColTimeRW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.xVel[n] > 0.0 && this.neighbor[3] == null) {
            if (this.xPos[n] + this.rad[n] < this.rwpos) {
                return Math.max(0.0, (this.rwpos - this.rad[n] - this.xPos[n]) / this.xVel[n]);
            }
            if (this.xPos[n] < this.rwpos) {
                return Math.max(0.0, (this.rwpos - this.xPos[n]) / this.xVel[n]);
            }
        }
        return 10000.0;
    }

    public void collideRW(int n) {
        if (this.empty[n]) {
            System.out.println("Right: empty particle colliding");
            return;
        }
        this.pr += Math.abs(this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        if (this.owner.flows && this.oRProb > Math.random()) {
            this.oflowPart(n);
            return;
        }
        if (this.neighbor[3] != null) {
            this.xPos[n] = this.lwpos;
        } else if (this.therms[1]) {
            this.thermalize(n, 1);
        } else {
            this.xVel[n] = -this.xVel[n];
        }
        this.pr += Math.abs(-this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.lwColTimes[n] = this.calcColTimeLW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        if (this.owner.partInt) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    public void collideLW(int n) {
        if (this.empty[n]) {
            System.out.println("Right: empty particle colliding");
            return;
        }
        if (this.yPos[n] > this.owner.ensemble3.bwpos && this.yPos[n] < this.owner.ensemble3.twpos && (double)2 * this.rad[n] < this.owner.ensemble3.twpos - this.owner.ensemble3.bwpos - 0.002) {
            double d = this.xVel[n];
            double d2 = this.yVel[n];
            double d3 = this.rad[n];
            this.yPos[n] = d3 + Math.max(this.yPos[n] - d3, this.owner.ensemble3.bwpos + 0.001);
            this.yPos[n] = -d3 + Math.min(this.yPos[n] + d3, this.owner.ensemble3.twpos - 0.001);
            double d4 = this.yPos[n] - this.owner.ensemble3.yOrigin;
            double d5 = this.owner.ensemble3.rwpos - 1.0E-4 - this.owner.ensemble3.xOrigin;
            this.owner.ensemble3.setDefaultColor(this.colors[n].getRed(), this.colors[n].getGreen(), this.colors[n].getBlue());
            this.owner.ensemble3.setDefaultMass(this.mass[n]);
            this.owner.ensemble3.addParticle(d5, d4, d, d2, d3);
            this.removeParticle(n);
        } else {
            this.xVel[n] = -this.xVel[n];
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            if (this.owner.partInt) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    this.colTimes[n][n2] = this.calcColTime(n, n2);
                }
                for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                    this.colTimes[n2][n] = this.calcColTime(n2, n);
                }
            }
        }
    }

    void iflowPart() {
        boolean bl = false;
        if (this.applet.clock.isRunning()) {
            this.pause();
            bl = true;
        }
        Color color = this.dcolor;
        this.dcolor = Color.green;
        double d = this.dsize;
        this.setParticle(this.findEmptyPart(), this.rwpos - this.dsize - 0.001, 0.001 + d + Math.random() * (this.twpos - d - d - 0.002), -Math.random() * (double)10, (1.0 - (double)2 * Math.random()) * (double)10, d);
        this.recalculateColTimes();
        this.dcolor = color;
        if (bl) {
            this.forward();
        }
    }

    public void findMinColTime() {
        if (this.empty == null) {
            return;
        }
        double d = this.applet.clock.getDt();
        double d2 = 10000.0;
        double d3 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d2) {
                d2 = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
                if (d2 <= 0.0) {
                    System.out.println("Right: tWColTime <= 0");
                    this.pause();
                }
            }
            if (this.rwColTimes[0] < d2) {
                d2 = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
                if (d2 <= 0.0) {
                    System.out.println("Right: rWColTime <= 0");
                    this.pause();
                }
            }
            if (this.bwColTimes[0] < d2) {
                d2 = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
                if (d2 <= 0.0) {
                    System.out.println("Right: bWColTime <= 0");
                    this.pause();
                }
            }
            if (this.lwColTimes[0] < d2) {
                d2 = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
                if (d2 <= 0.0) {
                    System.out.println("Right: LWColTime <= 0");
                    this.pause();
                }
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d2) {
                d2 = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
                if (d2 <= 0.0) {
                    System.out.println("Right: tWColTime <= 0");
                    this.pause();
                }
            }
            if (this.rwColTimes[i] < d2) {
                d2 = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
                if (d2 <= 0.0) {
                    System.out.println("Right: rWColTime <= 0");
                    this.pause();
                }
            }
            if (this.bwColTimes[i] < d2) {
                d2 = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
                if (d2 <= 0.0) {
                    System.out.println("Right: bWColTime <= 0");
                    this.pause();
                }
            }
            if (this.lwColTimes[i] < d2) {
                d2 = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
                if (d2 <= 0.0) {
                    System.out.println("Right: LWColTime <= 0");
                    this.pause();
                }
            }
            if (!this.owner.partInt) continue;
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d2)) continue;
                d2 = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
                if (!(d2 <= 0.0)) continue;
                System.out.println("Right: PartColTime <= 0");
                this.pause();
            }
        }
        if (d2 < 0.0) {
            System.out.println("Right: negative Collide Time");
            this.pause();
            d2 = 10000.0;
        }
        if (d2 == 0.0) {
            System.out.println("Right: Collide Time = 0");
            this.pause();
            d2 = 10000.0;
        }
        this.temptime = this.mint = d2;
    }

    public synchronized void paintOSI() {
        int n = (int)((this.rwpos - this.lwpos) * (double)this.ppu);
        int n2 = (int)(this.lwpos * (double)this.ppu);
        int n3 = (int)((this.twpos - this.bwpos) * (double)this.ppu);
        if (this.owner.osi != null) {
            double d;
            Graphics graphics = this.owner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(this.bgColor);
            graphics.fillRect(n2, 0, n, n3);
            int n4 = 1;
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                graphics.setColor(this.colors[i]);
                d = this.rad[i];
                n4 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
                if (!this.periodicv) continue;
                if (this.yPos[i] + d > this.twpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d - this.twpos)), n4, n4);
                }
                if (!(this.yPos[i] - d < this.bwpos)) continue;
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d + this.twpos)), n4, n4);
            }
            if (this.therms[0]) {
                // empty if block
            }
            if (this.therms[1]) {
                // empty if block
            }
            if (this.therms[2]) {
                // empty if block
            }
            if (this.therms[3]) {
                // empty if block
            }
            for (int i = 0; i < this.owner.ensemble3.lastpartnum + 1; ++i) {
                if (this.owner.ensemble3.empty[i] || !(this.owner.ensemble3.xPos[i] + (d = this.owner.ensemble3.rad[i]) > this.lwpos)) continue;
                n4 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.setColor(this.owner.ensemble3.colors[i]);
                graphics.fillOval((int)((double)this.ppu * (this.owner.ensemble3.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.owner.ensemble3.yPos[i] + d)), n4, n4);
            }
            if (this.showMessage) {
                this.paintMessage(graphics);
            }
            graphics.dispose();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.applet.clock.isRunning()) {
                bl2 = true;
                this.pause();
            }
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
            if (bl2) {
                this.forward();
            }
        }
    }

    public void recalculateColTimes() {
        this.owner.recalculateColTimes();
    }
}

