/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import java.awt.Color;
import java.awt.Graphics;
import molecular.Ensemble;
import molecular.EnsemblePanel;
import molecular.MEnsemblePanel;

public class MREnsemble
extends Ensemble {
    MEnsemblePanel towner = null;

    public MREnsemble(EnsemblePanel ensemblePanel) {
        super(ensemblePanel);
        this.towner = (MEnsemblePanel)ensemblePanel;
        this.dcolor = new Color(150, 0, 0);
    }

    public void setBounds() {
        this.towner.setBounds();
    }

    public double calcColTimeLW(int n) {
        if (this.empty[n]) {
            System.out.println(String.valueOf("calcColTimeLW empty particle:").concat(String.valueOf(n)));
            return 10000.0;
        }
        if (this.xVel[n] < 0.0 && this.xPos[n] > this.lwpos) {
            return Math.abs((this.lwpos - this.xPos[n]) / this.xVel[n]);
        }
        return 10000.0;
    }

    public void findMinColTime() {
        double d = 10000.0;
        double d2 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d) {
                d = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
            }
            if (this.rwColTimes[0] < d) {
                d = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
            }
            if (this.bwColTimes[0] < d) {
                d = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
            }
            if (this.lwColTimes[0] < d) {
                d = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d) {
                d = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
                if (d <= 0.0) {
                    System.out.println("tWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.rwColTimes[i] < d) {
                d = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
                if (d <= 0.0) {
                    System.out.println("rWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.bwColTimes[i] < d) {
                d = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
                if (d <= 0.0) {
                    System.out.println("bWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.lwColTimes[i] < d) {
                d = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
                if (d <= 0.0) {
                    System.out.println("LWColTime <= 0: Right");
                    this.pause();
                }
            }
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d)) continue;
                d = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
                if (!(d <= 0.0)) continue;
                System.out.println("PartColTime <= 0: Right");
                this.pause();
            }
        }
        if (d < 0.0) {
            System.out.println("negative Collide Time: Right");
            this.pause();
            d = 10000.0;
        }
        if (d == 0.0) {
            System.out.println("Collide Time = 0: Right");
            this.pause();
            d = 10000.0;
        }
        this.temptime = this.mint = d;
    }

    public void collideLW(int n) {
        if (this.empty[n]) {
            return;
        }
        double d = 0.0;
        this.pl += Math.abs((double)2 * this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        d = this.towner.pparser.evaluate(this.mass[n]);
        if (d > Math.random()) {
            double d2 = this.yPos[n] - this.towner.ensemble1.yOrigin;
            double d3 = this.xVel[n];
            double d4 = this.yVel[n];
            double d5 = this.rad[n];
            double d6 = this.towner.ensemble2.rwpos - 1.0E-4 - this.towner.ensemble2.xOrigin;
            this.towner.ensemble1.setDefaultColor(this.colors[n].getRed(), this.colors[n].getGreen(), this.colors[n].getBlue());
            this.towner.ensemble1.setDefaultMass(this.mass[n]);
            this.towner.ensemble1.addParticle(d6, d2, d3, d4, d5);
            this.removeParticle(n);
        } else {
            int n2;
            this.xVel[n] = -this.xVel[n];
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    public synchronized void paintOSI() {
        int n = (int)((this.rwpos - this.lwpos) * (double)this.ppu);
        int n2 = (int)(this.lwpos * (double)this.ppu);
        int n3 = (int)((this.twpos - this.bwpos) * (double)this.ppu);
        if (this.towner.osi != null) {
            Graphics graphics = this.towner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            int n4 = 1;
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                graphics.setColor(this.colors[i]);
                double d = this.rad[i];
                n4 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
                if (this.xPos[i] + d > this.rwpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d - this.rwpos)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
                }
                if (this.yPos[i] + d > this.twpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d - this.twpos)), n4, n4);
                }
                if (this.yPos[i] - d < this.bwpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d + this.twpos)), n4, n4);
                }
                if (!(this.xPos[i] - d < this.lwpos)) continue;
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d + this.rwpos)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
            }
            if (this.therms[0]) {
                // empty if block
            }
            if (this.therms[1]) {
                // empty if block
            }
            if (this.therms[2]) {
                // empty if block
            }
            if (this.therms[3]) {
                // empty if block
            }
            if (this.showMessage) {
                this.paintMessage(graphics);
            }
            graphics.dispose();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.applet.clock.isRunning()) {
                bl2 = true;
                this.pause();
            }
            this.recalculateColTimes();
            this.paintOSI();
            this.towner.repaint();
            if (bl2) {
                this.forward();
            }
        }
    }

    public void recalculateColTimes() {
        this.towner.recalculateColTimes();
    }
}

