/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.display.SInteger;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import molecular.Ensemble;
import molecular.EnsemblePanel;

public class MolecularApplet
extends SApplet {
    boolean isStandalone = false;
    boolean firstTime = true;
    boolean sc;
    boolean perh;
    boolean per;
    boolean perv;
    int inp;
    int maxp;
    int fps;
    int ppu;
    int mode;
    int bwidth;
    boolean bill = false;
    double dt = 0.1;
    Ensemble ensemble1 = null;
    EnsemblePanel ensemblePanel = new EnsemblePanel(this);
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button startbtn = new Button();
    Button resetbtn = new Button();
    Button stepbtn = new Button();
    Panel panel1 = new Panel();
    Label label1 = new Label();
    SInteger partfield = new SInteger();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        this.ensemble1 = this.ensemblePanel.getEnsemble();
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.inp = Integer.parseInt(this.getParameter("InitialP", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ppu = Integer.parseInt(this.getParameter("PixPerUnit", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dt = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.perh = Boolean.valueOf(this.getParameter("PeriodicH", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.perv = Boolean.valueOf(this.getParameter("PeriodicV", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.maxp = Integer.parseInt(this.getParameter("MaxParticles", "80"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.bwidth = Integer.parseInt(this.getParameter("Border", "5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.addClockListener((SStepable)this.ensemble1);
        this.setBorderWidth(this.bwidth);
        this.setMaxParticles(this.maxp);
        this.setFPS(this.fps);
        this.setDt(this.dt);
        this.setPpu(this.ppu);
        this.setShowControls(this.sc);
        this.setPeriodicV(this.perv);
        this.setPeriodicH(this.perh);
        this.setDefaultSize(1.0);
        this.setRunningID();
        this.setBackgroundRGB(150, 150, 150);
        ((Component)((Object)this)).setBackground(Color.gray);
        this.partfield.setValue(this.inp);
        this.ensemblePanel.ensemble1.setEnableMouse(true);
    }

    private void jbInit() throws Exception {
        this.startbtn.setLabel("Go!");
        this.startbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularApplet.this.startbtn_actionPerformed(actionEvent);
            }
        });
        this.resetbtn.setLabel("Reset");
        this.stepbtn.setLabel("Step");
        this.resetbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularApplet.this.resetbtn_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.borderLayout1);
        this.label1.setAlignment(1);
        this.label1.setText("New  Particles:");
        this.partfield.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                MolecularApplet.this.partfield_textValueChanged(textEvent);
            }
        });
        ((Component)((Object)this)).setSize(new Dimension(392, 256));
        this.ensemblePanel.setLayout(this.borderLayout4);
        this.stepbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularApplet.this.stepbtn_actionPerformed(actionEvent);
            }
        });
        this.etchedBorder3.setLayout(this.gridLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        ((Container)((Object)this)).setLayout(this.borderLayout3);
        ((Container)((Object)this)).add(this.ensemblePanel, "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.etchedBorder3, "Center");
        this.etchedBorder3.add((Component)this.startbtn, null);
        this.etchedBorder3.add((Component)this.resetbtn, null);
        this.etchedBorder3.add((Component)this.stepbtn, null);
        this.controlPanel.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.label1, "Center");
        this.panel1.add((Component)this.partfield, "East");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", ""}, {"InitialP", "int", "number of particles"}, {"Mode", "String", ""}, {"Frames", "double", "frames per second"}, {"PixPer", "int", "pixels per unit"}, {"Delta", "double", "time step"}};
        return stringArray;
    }

    public void start() {
        super.start();
        this.ensemblePanel.osi = null;
        if (this.firstTime) {
            this.pause();
            this.firstTime = false;
            this.ensemble1.setDefault();
        }
        ((Component)((Object)this)).repaint();
    }

    public void setShowControls(boolean bl) {
        this.controlPanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setMessage(String string) {
        this.ensemble1.setMessage(string);
    }

    public void setRGB(int n, int n2, int n3) {
        this.ensemblePanel.txtcolor = new Color(n, n2, n3);
    }

    public void setDisplayOffset(int n, int n2) {
        if (n >= 0) {
            this.ensemblePanel.txtxoff = n;
        }
        if (n2 >= 0) {
            this.ensemblePanel.txtyoff = n2;
        }
    }

    public void addCaption(String string) {
        this.ensemblePanel.addCaption(string);
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.pause();
        this.ensemble1.setDefault();
    }

    void startbtn_actionPerformed(ActionEvent actionEvent) {
        if (!this.clock.isRunning()) {
            this.createParticles(this.inp);
            this.forward();
        } else {
            this.pause();
        }
    }

    public void setDefault() {
        this.clock.stopClock();
        this.ensemble1.setDefault();
        this.setDefaultMass(1.0);
        this.setDefaultSize(1.0);
        this.setDefaultColor(50, 0, 170);
        this.ensemble1.showMessage = false;
        this.ensemblePanel.showTitle = false;
    }

    public void pause() {
        this.clock.stopClock();
        this.startbtn.setLabel("Start");
    }

    public void forward() {
        this.setRunningID();
        this.startbtn.setLabel("Pause");
        this.clock.startClock();
    }

    void partfield_textValueChanged(TextEvent textEvent) {
        this.pause();
        this.inp = this.partfield.getValue();
    }

    void resetbtn_actionPerformed(ActionEvent actionEvent) {
        this.pause();
        this.ensemble1.setDefault();
    }

    void stepbtn_actionPerformed(ActionEvent actionEvent) {
        this.stepForward();
    }

    public void stepForward() {
        this.clock.doStep();
    }

    public int addParticle(double d, double d2, double d3, double d4, double d5) {
        return this.ensemble1.addParticle(d, d2, d3, d4, d5);
    }

    public void createParticles(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.ensemble1.createParticles(n);
        if (bl) {
            bl = false;
            this.forward();
        }
    }

    public void setParticles(int n) {
        this.ensemble1.setParticles(n);
    }

    public void setTemp(double d) {
        this.ensemble1.setTemp(d);
    }

    public void setTemperature(double d, int n) {
        this.ensemble1.setTemperature(d, n);
    }

    public void removeParticle(int n) {
        this.ensemble1.removeParticle(n);
    }

    public void setMaxParticles(int n) {
        this.ensemble1.setMaxParticles(n);
    }

    public void setBackgroundRGB(int n, int n2, int n3) {
        this.ensemble1.setBackgroundRGB(n, n2, n3);
    }

    public void setDefaultMass(double d) {
        this.ensemble1.setDefaultMass(d);
    }

    public void setDefaultSize(double d) {
        this.ensemble1.setDefaultSize(d);
    }

    public void setDefaultColor(int n, int n2, int n3) {
        this.ensemble1.setDefaultColor(n, n2, n3);
    }

    public void setDefaultTemp(double d) {
        this.ensemble1.setDefaultTemp(d);
    }

    public void setParticleRGB(int n, int n2, int n3, int n4) {
        this.ensemble1.setParticleRGB(n, n2, n3, n4);
    }

    public void setParticleMass(int n, double d) {
        this.ensemble1.setParticleMass(n, d);
    }

    public void setBorderWidth(int n) {
        this.ensemble1.setBorderWidth(n);
    }

    public void setParticlePos(int n, double d, double d2) {
        this.ensemble1.setParticlePos(n, d, d2);
    }

    public void setParticleVel(int n, double d, double d2) {
        this.ensemble1.setParticleVel(n, d, d2);
    }

    public void setParticleSize(int n, double d) {
        this.ensemble1.setParticleSize(n, d);
    }

    public int addParticleDataSource(int n) {
        return this.ensemble1.addParticleDataSource(n);
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.ensemble1.setAutoRefresh(bl);
    }

    public void setBoltzmann(double d) {
        this.ensemble1.setBoltzmann(d);
    }

    public void setWallTemp(String string, double d) {
        string.toLowerCase();
        string.trim();
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.setWallTemp(0, d);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble1.setWallTemp(1, d);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.setWallTemp(2, d);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.setWallTemp(3, d);
        }
    }

    public void removeWallTemp(String string) {
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.removeWallTemp(0);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble1.removeWallTemp(1);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.removeWallTemp(2);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.removeWallTemp(3);
        }
    }

    public void setPpu(int n) {
        this.ensemble1.setPpu(this.ppu);
    }

    public void setPeriodicH(boolean bl) {
        this.pause();
        this.ensemble1.setPeriodicH(bl);
    }

    public void setPeriodicV(boolean bl) {
        this.pause();
        this.ensemble1.setPeriodicV(bl);
    }

    public double getRWPos() {
        return this.ensemble1.getRWPos();
    }

    public double getLWPos() {
        return this.ensemble1.getLWPos();
    }

    public double getTWPos() {
        return this.ensemble1.getTWPos();
    }

    public double getBWPos() {
        return this.ensemble1.getBWPos();
    }

    public int getEnsembleID() {
        return this.ensemble1.hashCode();
    }

    public int getHistogramID(int n, double d, double d2) {
        return this.ensemble1.setHistogram(n, d, d2);
    }

    public int getParticleID(int n) {
        return this.ensemble1.addParticleDataSource(n);
    }
}

